//------------------------------------------------
// fastec_utils.js
//
// Copyright 2018 (c) Fastec Imaging as an unpublished work.
// All Rights Reserved.
//
// The information contained herein is confidential property of
// Fastec Imaging. The use, copying, transfer or disclosure of such
// information is prohibited except by express written agreement
// with Fastec Imaging.
//
// The Fastec Imaging Camera Control Web Application
// Common Utility Functions for Application
//------------------------------------------------

//------------------------------------------------------------------------------
// common handler output message to console
//------------------------------------------------------------------------------
function fastecLogToConsole(theType, theMessageToUse) {
    if (gDebugging) {
        if (theType == gLogAll && gAllowAllLog) console.log(theMessageToUse);
        else if (theType == gLogStatePolling && gAllowStatePollingLog)
            console.log(theMessageToUse);
        else if (theType == gLogStateWaitingHits && gAllowStateWaitingHitsLog)
            console.log(theMessageToUse);
        else if (theType == gLogCurrentJPG && gAllowCurrentJPGLog)
            console.log(theMessageToUse);
        else if (
            theType == gLogLiveViewImageLoads &&
            gAllowLiveViewImageLoadsLog
        )
            console.log(theMessageToUse);
        else if (theType == gLogRecSetUpdates && gAllowRecSetUpdatesLog)
            console.log(theMessageToUse);
        else if (theType == gLogElapsedTimes && gAllowLogElapsedTimes)
            console.log(theMessageToUse);
        else if (theType == gLogTriggerInfo && gAllowTriggerInfo)
            console.log(theMessageToUse);
        else if (theType == gLogVideoSaveInfo && gAllowLogVideoSaveInfo)
            console.log(theMessageToUse);
        else if (theType == gLogFactoryDebug && gAllowLogFactoryDebug)
            console.log(theMessageToUse);
        else if (theType == gLogCtrlObjEvts && gAllowLogCtrlObjEvts)
            console.log(theMessageToUse);
        else if (theType == gLogUpdateEvts && gAllowLogUpdateEvts)
            console.log(theMessageToUse);
        else if (theType == gLogSpecialCaseEvts && gAllowSpecialCaseEvts)
            console.log(theMessageToUse);
        else if (theType == gLogEventInfo && gAllowLogEventInfo)
            console.log(theMessageToUse);
        else if (theType == gLogVideoRevEvts && gAllowLogVideoRevEvts)
            console.log(theMessageToUse);
        else if (theType == gLogStorageEvts && gAllowStorageEvts)
            console.log(theMessageToUse);
        else if (theType == gLogCamSetEvts && gAllowCamSetEvts)
            console.log(theMessageToUse);
        else if (theType == gLogFileActionInfo && gAllowLogFileActionInfo)
            console.log(theMessageToUse);
        else if (theType == gLogPBStateInfo && gAllowLogPBStateInfo)
            console.log(theMessageToUse);
        else if (theType == gLogTrace && gAllowTrace)
            console.log(theMessageToUse);
    }
}

//------------------------------------------------------------------------------
// common handler to return the current time
//------------------------------------------------------------------------------
function getMyCurrentTime() {
    var d = new Date();
    return d.getTime();
}

//---------------------------------------
// Compares strings to see if they are equal and
// returns true if so or false if not
//---------------------------------------
function fastecStringCompare(a, b) {
    var aStr = a.toUpperCase();
    var bStr = b.toUpperCase();

    if (aStr.length == bStr.length) {
        var x;
        for (x = 0; x < aStr.length; x++) {
            if (aStr.charAt(x) != bStr.charAt(x)) return false; // not equal
        }
        return true; // they are equal
    }
    return false; // they are not equal
}

//------------------------------------------------------------------------------
// common handler to log time to the debugging console
//------------------------------------------------------------------------------
function fastecLogTimeToConsole(theType, theMessageToUse) {
    var d = new Date();
    //d.toUTCString();
    var message = theMessageToUse + " " + d.getTime();
    fastecLogToConsole(theType, message);
}

//------------------------------------------------------------------------------
// common handler to track elapsed time
//------------------------------------------------------------------------------
function fastecElapsedRec(theMessageToUse) {
    this.theMessageToUse = theMessageToUse;
    this.d = new Date();

    // ability to reset the elapsed record
    this.resetStartTime = function() {
        this.d = new Date();
    };

    // ability to output elapsed statistics to console
    this.showElapsed = function() {
        var d2 = new Date();
        var deltaTime = d2.getTime() - this.d.getTime();
        var logMessage = this.theMessageToUse + " elapsed(ms): " + deltaTime;
        fastecLogToConsole(gLogElapsedTimes, logMessage);
    };
}

//---------------------------------------
// Internet Address Utility
// takes hexidecimal address from Camera Server
// and returns a subcomponent part.
// the the valid values for thePartWanted
// fall into this format: 0.1.2.3
//
//---------------------------------------
function fastecGetINETPart(thePartWanted, theINETHex) {
    var thePart = 0; // invalid part
    var theINETString = "" + theINETHex;

    // check length
    if (theINETString.length < 8) return thePart;
    // check part requested
    if (thePartWanted < 0 || thePartWanted > 3) return thePart;

    var theIndex = thePartWanted * 2;
    var theINETPart = theINETString.substr(theIndex, 2);

    // convert to decimal number
    return parseInt(theINETPart, 16);
}

//---------------------------------------
// format a hex code word and zero pad if only 1 char
//---------------------------------------
function fastecPullPaddedHexWord(in_HexStr) {
    theHexCodeWord = "00";
    if (in_HexStr.length <= 0) return theHexCodeWord;
    if (in_HexStr.length == 1) theHexCodeWord = "0" + in_HexStr;
    else theHexCodeWord = in_HexStr.substr(0, 2); // truncate if more than two characters.
    return theHexCodeWord;
}

//---------------------------------------
// zero pad a hexadecimal word to full 8 characters on left
//---------------------------------------
function fastecZeroPadFullHexWord(in_HexStr) {
    // the length of padded hex word is 8 bytes
    var lengthNeeded = 8;
    var hexZeroPadChar = "0";

    var paddedHexStr = in_HexStr;

    while (paddedHexStr.length != lengthNeeded) {
        paddedHexStr = hexZeroPadChar + paddedHexStr; // zero pad.
    }

    return paddedHexStr;
}

//---------------------------------------
// Internet Address Compact Utility
// takes internet components and compacts them into
// a 32 bit register
//
// returns the 32 bit register in hex form
//---------------------------------------
function fastecMakeINETReg(ipOne, ipTwo, ipThree, ipFour) {
    //var aTest = 0xFFFFFFFF;
    //var bTest = fastecHexToDec(aTest);
    //var cTest = fastecDecToHex(bTest);

    var ipOneStr = fastecDecToHex(ipOne);
    var ipTwoStr = fastecDecToHex(ipTwo);
    var ipThreeStr = fastecDecToHex(ipThree);
    var ipFourStr = fastecDecToHex(ipFour);

    ipOneStr = fastecPullPaddedHexWord(ipOneStr);
    ipTwoStr = fastecPullPaddedHexWord(ipTwoStr);
    ipThreeStr = fastecPullPaddedHexWord(ipThreeStr);
    ipFourStr = fastecPullPaddedHexWord(ipFourStr);

    // make sure the system understands this is in hex
    var theINetRegInHex = "0x" + ipFourStr + ipThreeStr + ipTwoStr + ipOneStr;
    return theINetRegInHex;
}

/*
 $user_ip = explode(".", $_SERVER['REMOTE_ADDR']); 
 
 $w=$user_ip[0]; 
 $x=$user_ip[1]; 
 $y=$user_ip[2]; 
 $z=$user_ip[3]; 
 
 $ipnum = 16777216*$w + 65536*$x + 256*$y + $z; 
 
 String ntoa(long raw) {
 byte[] b = new byte[] {(byte)(raw >> 24), (byte)(raw >> 16), (byte)(raw >> 8), (byte)raw};
 try {
 return InetAddress.getByAddress(b).getHostAddress();
 } catch (UnknownHostException e) {
 //No way here
 return null;
 }
 }	
 */

//---------------------------------------
// integer casting
//---------------------------------------
function fastecMakeInteger(theNumberToCast) {
    var theDecimalPart = theNumberToCast % 1;
    var theInteger = theNumberToCast - theDecimalPart;
    return theInteger;
}

//---------------------------------------
// Translate Seconds into Milleseconds
//---------------------------------------
function fastecSecToMSec(x) {
    var mSec = x * 1000;
    var mSecFract = mSec % 1;
    mSec = mSec - mSecFract; // strip fractional part

    //var ck999 = mSecFract * 1000;
    //var ck999Fract = ck999 % 1;
    //ck999 = ck999 - ck999Fract;
    //if( ck999 == 999 )
    //    mSec++;

    // if greater than 5000 round the mSec up by 1
    var ckFract = mSecFract * 1000;
    if (ckFract > 500) mSec++;

    return mSec;
}

//---------------------------------------
// Translate Milleseconds into Seconds
//---------------------------------------
function fastecMSecToSec(x) {
    var sec = x / 1000;
    return sec;
}

//------------------------------------------
// odd/even tests
//------------------------------------------
function fastecIsEven(x) {
    return x % 2 == 0;
}

function fastecIsOdd(x) {
    return !fastecIsEven(x);
}

//------------------------------------------
// hex to decimal interchange
//------------------------------------------
function fastecDecToHex(in_number) {
    var number = new Number(in_number);
    if (number < 0) {
        number = 0xffffffff + number + 1;
    }

    var hexNbr = number.toString(16).toUpperCase();
    // want to always have a word boundary here...
    if (fastecIsOdd(hexNbr.length)) hexNbr = "0" + hexNbr;
    return hexNbr;
}

function fastecHexToDec(h) {
    return parseInt(h, 16);
}

//------------------------------------------
// Converts Hexidecimal string into ASCII string
//------------------------------------------
function fastecHexToAscii(hex) {
    var str = "";
    for (var i = 0; i < hex.length; i += 2) {
        var theHexValue = parseInt(hex.substr(i, 2), 16);
        if (theHexValue < 32 || theHexValue > 126) {
            // convert to a blank ascii decimal value because it is unprintable
            theHexValue = 32;
        }
        str += String.fromCharCode(theHexValue);
    }
    return str;
}

//------------------------------------------
// Empty an Array of Objects
//------------------------------------------
function fastecEmptyThisArray(inArrayToEmpty) {
    var nPops = inArrayToEmpty.length;
    for (var i = 0; i < nPops; i++) inArrayToEmpty.pop();
    return;
}

//------------------------------------------
// CS Register Utilities pull a byte from register
//
// in_csRegFromINGE is the register value from INGE
// in_byteToPull is 0-based byte to pull where 0 is the low byte
// and 3 is the highest byte of 4 byte register - hex bytes are
// represented by two string characters - 0xFF is full byte
//
// returns the hexidecimal 2 character string for the byte
//------------------------------------------
function csRegPullByte(in_csRegFromINGE, in_byteToPull) {
    var hexNbr = fastecDecToHex(in_csRegFromINGE);
    var hexStr = "00000000";
    var out_hexByteStr = "00";

    // if the byte to pull is out of range can't return 00
    if (in_byteToPull < 0 || in_byteToPull > 3) return out_hexByteStr; // the byte to pull wasn't valid

    // install the hex number representation of register
    hexStr = hexNbr;

    // if the length isn't a full string-zero pad the value
    if (hexNbr.length < 8) {
        // set the hexByteStr to the current hex
        // how many zeros to pad left?
        var nZeroes = 8 - hexNbr.length;
        while (nZeroes > 0) {
            hexStr = "0" + hexStr;
            nZeroes--;
        }
    }

    // now pull out only the bytes needed from zero-padded full register in hex
    // index hex str: 0 2 4 6
    // hex str:       00FF00FF
    // byte to pull:  3 2 1 0   -- lowest byte is 0... to highest byte 3
    var indexToSlice = 0;
    if (in_byteToPull == 0) indexToSlice = 6;
    else if (in_byteToPull == 1) indexToSlice = 4;
    else if (in_byteToPull == 2) indexToSlice = 2;
    else indexToSlice = 0;

    // slice out the two byte hex code needed
    out_hexByteStr = hexStr.slice(indexToSlice, indexToSlice + 2);

    return out_hexByteStr; // return the two byte slice of the register in hex characters (minus the 0x)
}

//------------------------------------------
// CS Register Utilities pull low/high words in hex
// assume that incoming register is not in hex
// return value is string with hex characters and
// zero padded left to fill hex word
//------------------------------------------
function csRegLoWord(csRegFromINGE) {
    var hexNbr = fastecDecToHex(csRegFromINGE);
    var loWordStr = "";
    if (hexNbr.length >= 4) loWordStr = hexNbr.slice(hexNbr.length - 4);
    else if (hexNbr.length == 3) loWordStr = "0" + hexNbr;
    else if (hexNbr.length == 2) loWordStr = "00" + hexNbr;
    else if (hexNbr.length == 1) loWordStr = "000" + hexNbr;
    else loWordStr = "0000";
    return loWordStr;
}

function csRegHiWord(csRegFromINGE) {
    var hexNbr = fastecDecToHex(csRegFromINGE);
    var hiWordStr = "";
    if (hexNbr.length > 4) {
        var lenToMove = hexNbr.length - 4;
        if (lenToMove > 4) lenToMove = 4;
        hiWordStr = hexNbr.slice(0, lenToMove);
    }
    if (hiWordStr.length == 3) hiWordStr = "0" + hiWordStr;
    else if (hiWordStr.length == 2) hiWordStr = "00" + hiWordStr;
    else if (hiWordStr.length == 1) hiWordStr = "000" + hiWordStr;
    else if (hiWordStr.length != 4) hiWordStr = "0000";
    return hiWordStr;
}

// expects a 4 byte string of hex numbers without
// leading 0x -- will pad left with zeros!
function csFlipWords(csHexStrFourChars) {
    var hexNbr = csHexStrFourChars;
    var wordStr = "";
    if (hexNbr.length >= 4) wordStr = hexNbr.slice(hexNbr.length - 4);
    else if (hexNbr.length == 3) wordStr = "0" + hexNbr;
    else if (hexNbr.length == 2) wordStr = "00" + hexNbr;
    else if (hexNbr.length == 1) wordStr = "000" + hexNbr;
    else wordStr = "0000";

    // flip the two left with two on right
    var flip1 = wordStr.slice(0, 2);
    var flip2 = wordStr.slice(2, 4);
    var hold = flip2 + flip1;
    wordStr = hold;

    return wordStr;
}

//---------------------------------------
// celsius temperature formatter
//---------------------------------------
function fmtCelsiusTemp(inTempFromCS) {
    try {
        var strFmt = inTempFromCS.toString(10);
        var strLen = strFmt.length;
        if (strLen > 0) {
            var tempStr = strFmt.slice(0, strLen - 1);
            tempStr = tempStr + ".";
            var tenthsStr = strFmt.charAt(strLen - 1);
            tempStr = tempStr + tenthsStr;
            return tempStr;
        } else return "0.0";
    } catch (err) {
        var theDetails = "caught: v-" + err.description;
        gFaultHandler.logError(theDetails);
    }
}

//---------------------------------------
// date format for tag string
//---------------------------------------
function getDateForTag() {
    try {
        var d = new Date();
        var year = d.getFullYear();
        var mon = d.getMonth() + 1;
        var day = d.getDate();

        if (mon < 10) mon = "0" + mon;
        if (day < 10) day = "0" + day;

        var tagStr = year + "-" + mon + "-" + day;
        return tagStr;
    } catch (err) {
        var theDetails = "getDateForTag() caught: v-" + err.description;
        gFaultHandler.logError(theDetails);
    }
}

//---------------------------------------
// time formatter
//---------------------------------------
function fmtDisplayTime(inTimeInSeconds) {
    try {
        this.tstr = "0";
        this.hours = 0;
        this.minutes = 0;
        this.seconds = 0;
        this.ms = 0;
        this.theTimeInSeconds = inTimeInSeconds;

        // if hours are involved determine how many
        if (this.theTimeInSeconds >= 3600.0) {
            this.hours = this.theTimeInSeconds / 3600;
            var minPart = this.hours % 1;
            this.hours = this.hours - minPart; // strip fractional part
            this.theTimeInSeconds = this.theTimeInSeconds - this.hours * 3600; // reduce for minute test
        }
        // if minutes are involved determine how many
        if (this.theTimeInSeconds >= 60.0) {
            this.minutes = this.theTimeInSeconds / 60;
            var secPart = this.minutes % 1;
            this.minutes = this.minutes - secPart; // strip fractional part
            this.theTimeInSeconds = this.theTimeInSeconds - this.minutes * 60;
        }
        // set seconds and microseconds
        this.seconds = this.theTimeInSeconds;
        var msecPart = this.seconds % 1;
        this.seconds = this.seconds - msecPart;
        this.ms = fastecSecToMSec(msecPart);

        if (this.hours < 10) this.tstr = this.tstr + this.hours;
        else this.tstr = this.hours;
        this.tstr = this.tstr + ":";
        if (this.minutes < 10) this.tstr = this.tstr + "0";
        this.tstr = this.tstr + this.minutes + ":";
        if (this.seconds < 10) this.tstr = this.tstr + "0";

        var msFmt = "." + this.ms;
        if (msFmt.length == 1) msFmt = msFmt + "000";
        else if (msFmt.length == 2) msFmt = msFmt + "00";
        else if (msFmt.length == 3) msFmt = msFmt + "0";

        this.tstr = this.tstr + this.seconds + msFmt;

        this.getTimeStr = function() {
            return this.tstr;
        };

        //-------------------------------------------
        // accessors for returning different segments
        // of the time string
        //-------------------------------------------
        this.getHourStr = function() {
            var hourStr = "00";
            if (this.hours < 10) hourStr = "0" + this.hours;
            else hourStr = this.hours;
            return hourStr;
        };
        this.getMinStr = function() {
            var minStr = "00";
            if (this.minutes < 10) minStr = "0" + this.minutes;
            else minStr = this.minutes;
            return minStr;
        };
        this.getSecStr = function() {
            var secStr = "00";
            if (this.seconds < 10) secStr = "0" + this.seconds;
            else secStr = this.seconds;
            return secStr;
        };
        this.getMSStr = function() {
            var msStr = this.ms;
            return msStr;
        };
    } catch (err) {
        var theDetails = "caught: fmtDisplayTime-" + err.description;
        gFaultHandler.logError(theDetails);
    }
}

//---------------------------------------
// Pull Word out of Hex String from End
// Pad with a 0 if the full word is not
// or return null string if nothing was there
//---------------------------------------
function pullWordFromEnd(in_HexString) {
    var theWord = "";

    if (in_HexString.length <= 0) return theWord;

    if (in_HexString.length == 1) {
        theWord = "0";
        theWord = theWord + in_HexString.substr(index, 1);
    } else {
        var index = in_HexString.length - 2;
        theWord = in_HexString.substr(index, 1);
        index = in_HexString.length - 1;
        theWord = theWord + in_HexString.substr(index, 1);
    }
    return theWord;
}

//---------------------------------------
// MAC Address String formatter
//---------------------------------------
function formatMACString(inMAC_low, inMAC_high) {
    var MACString = "";
    var MAC_low = inMAC_low;
    var MAC_high = inMAC_high;

    // convert the decimal register values to hexadecimal
    MAC_high = fastecDecToHex(MAC_high);
    MAC_low = fastecDecToHex(MAC_low);

    // make sure the low MAC address is zero padded to full 8 bytes
    // or will lose precision on translation
    MAC_low = fastecZeroPadFullHexWord(MAC_low);

    // building the mac string up
    while (MAC_high.length > 0) {
        MACString = MACString + pullWordFromEnd(MAC_high);
        MACString = MACString + ":";
        if (MAC_high.length > 2)
            MAC_high = MAC_high.substr(0, MAC_high.length - 2);
        else MAC_high = "";
    }
    while (MAC_low.length > 0) {
        MACString = MACString + pullWordFromEnd(MAC_low);
        if (MAC_low.length > 2) {
            MAC_low = MAC_low.substr(0, MAC_low.length - 2);
            MACString = MACString + ":";
        } else MAC_low = "";
    }
    return MACString;
}

//---------------------------------------
// Get GIGE 4 Byte Register from String
//---------------------------------------
function getGIGE4ByteReg(ingeString) {}

//---------------------------------------
// image number formatter for Display returns a string
//---------------------------------------
function fmtImgStr(inImgNbr, nPrecision) {
    try {
        var x;
        var resultStr = "";
        resultStr = resultStr + inImgNbr;
        var resultLen = resultStr.length;

        // if the result length is larger than precision truncate
        if (resultLen > nPrecision) {
            var index = resultLen - nPrecision;
            resultStr = resultStr.slice(index, nPrecision);
            return resultStr;
        }

        // zero-pad if less
        for (x = resultLen; x < nPrecision; x++) resultStr = "0" + resultStr;

        return resultStr;
    } catch (err) {
        var theDetails = "caught: fmtImgNbr-" + err.description;
        gFaultHandler.logError(theDetails);
    }
}

//---------------------------------------
// image number formatter for Display to nDecimal Points
//---------------------------------------
function fmtImgStrToDecPlaces(inImgNbr, inDecimalsToAllow, inRoundIt) {
    try {
        var x;
        var srcStr = "";
        srcStr = srcStr + inImgNbr;
        var srcStrLen = srcStr.length;
        var srcStrRoundIndex = -1;

        if (srcStrLen <= 0) return srcStr;

        // find the location of a decimal point
        var index = srcStr.indexOf(".");
        if (index == -1) return srcStr; // no decimals

        // there is a decimal point
        var fmtImgStr = srcStr.slice(0, index);
        index++; // move past the decimal point

        var x;
        var lastIndexToAllow = index + inDecimalsToAllow;

        // keep within bounds of source string
        if (lastIndexToAllow >= srcStrLen) lastIndexToAllow = srcStrLen - 1;
        else if (inRoundIt) {
            // if rounding need to determine this value
            var theRoundIndex = lastIndexToAllow;
            if (theRoundIndex < srcStrLen) srcStrRoundIndex = theRoundIndex; // can use this index for rounding
        }
        // install the decimal place
        fmtImgStr = fmtImgStr + ".";

        // move the decmimal places
        for (x = index; x < lastIndexToAllow; x++) {
            // if last one to pull check for rounding and do so if set
            if (x == lastIndexToAllow - 1) {
                // pull current value
                var fmtChar = new Number(srcStr[x]);

                // if rounding set it up.
                if (srcStrRoundIndex != -1) {
                    var rndChar = new Number(srcStr[srcStrRoundIndex]);
                    if (rndChar >= 5 && fmtChar < 9) fmtChar++;
                }
                fmtImgStr = fmtImgStr + fmtChar.toString();
            } else fmtImgStr = fmtImgStr + srcStr[x];
        }

        return fmtImgStr;
    } catch (err) {
        var theDetails = "caught: fmtImgStrToDecPlaces-" + err.description;
        gFaultHandler.logError(theDetails);
    }
}

//---------------------------------------
// image number formatter for Display to nDecimal Points
//---------------------------------------
function fmtIntegerRoundUp(inImgNbr) {
    try {
        var x;
        var srcStr = "";
        srcStr = srcStr + inImgNbr;
        var srcStrLen = srcStr.length;
        var theInteger = fastecMakeInteger(inImgNbr);

        // find the location of a decimal point
        var index = srcStr.indexOf(".");
        if (index == -1) return theInteger; // no decimals

        index++; // move past the decimal point

        // if within bounds round up if needed
        if (index < srcStrLen) {
            var rndChar = new Number(srcStr[index]);
            if (rndChar >= 5) theInteger++; // round up.
        }
        return theInteger;
    } catch (err) {
        var theDetails = "caught: fmtIntegerRoundUp-" + err.description;
        gFaultHandler.logError(theDetails);
    }
}

//---------------------------------------
// image number formatter
//---------------------------------------
function fmtImgNbr(inImgNbr) {
    try {
        this.strImgNbr = "000";

        if (inImgNbr < 10) this.strImgNbr = "00" + inImgNbr;
        else if (inImgNbr < 100) this.strImgNbr = "0" + inImgNbr;
        else if (inImgNbr < 1000) this.strImgNbr = inImgNbr;
        else this.strImgNbr = "0000";
    } catch (err) {
        var theDetails = "caught: fmtImgNbr-" + err.description;
        gFaultHandler.logError(theDetails);
    }
}

//---------------------------------------
// disk space formatter
//---------------------------------------
function fmtDiskSpace(inDskSpaceToFmt) {
    try {
        // Setup the free space.
        var dskSpaceGB = 1024.0 * 1024.0 * 1024.0;
        var dskSpaceMB = 1024.0 * 1024.0;

        // the number in type
        var dskSpace = 0;

        // the place to store string
        var dspStr = "";

        if (inDskSpaceToFmt >= dskSpaceGB) {
            dskSpace = inDskSpaceToFmt / dskSpaceGB;
            dskSpace = fmtImgStrToDecPlaces(dskSpace, 1, true);
            dspStr = dskSpace + "GB";
        } else if (inDskSpaceToFmt >= dskSpaceMB) {
            dskSpace = inDskSpaceToFmt / dskSpaceMB;
            dskSpace = fmtImgStrToDecPlaces(dskSpace, 1, true);
            dspStr = dskSpace + "MB";
        } else {
            free_space = free_space / dskSpaceMB;
            dskSpace = fmtImgStrToDecPlaces(dskSpace, 1, true);
            dspStr = dskSpace + "KB";
        }
        return dspStr;
    } catch (err) {
        var theDetails = "caught: fmtDiskSpace-" + err.description;
        gFaultHandler.logError(theDetails);
    }
}

//------------------------------------
// common handler for scale/pan operations
//------------------------------------
function imgOps(ImgWidth, ImgHeight, fitToScreenWidth, fitToScreenHeight) {
    try {
        this.imgW = ImgWidth;
        this.imgH = ImgHeight;
        // maximum size of the image in 1 to 1 resolution

        this.dspW = fitToScreenWidth;
        this.dspH = fitToScreenHeight;
        // this is the size of the current display area for the image

        this.scaleFactorW = fitToScreenWidth / ImgWidth;
        this.scaleFactorH = fitToScreenHeight / ImgHeight;
        // this will reflect the scale factors used for displaying image

        this.scaleW = this.imgW * this.scaleFactorW;
        this.scaleH = this.imgH * this.scaleFactorH;
        // the scaled rectangles for current display (may be larger than Display Rectangle)

        this.scaleX = 0;
        this.scaleY = 0;
        // where does the left top corner of the scaled image reside

        // allocated and copies current state of this imgOps into new imgOps object and returns it.
        this.createACopy = function(inImgOps) {
            var newImgOps = new imgOps(
                this.imgW,
                this.imgH,
                this.dspW,
                this.dspH
            );
            return newImgOps;
        };

        //------------------------------------
        // coordinate conversions
        //------------------------------------
        this.imgToScaledX = function(inImgCoord) {
            var scaledCoord = inImgCoord * this.scaleFactorW;
            return scaledCoord;
        };
        this.imgToScaledY = function(inImgCoord) {
            var scaledCoord = inImgCoord * this.scaleFactorH;
            return scaledCoord;
        };
        this.scaledToImgX = function(inScaledCoord) {
            var imgCoord = inScaledCoord / this.scaleFactorW;
            return imgCoord;
        };
        this.scaledToImgY = function(inScaledCoord) {
            var imgCoord = inScaledCoord / this.scaleFactorH;
            return imgCoord;
        };

        //------------------------------------
        // handle a scale up
        //------------------------------------
        this.scaleUp = function() {
            this.scaleFactorW += 0.1;
            this.scaleFactorH += 0.1;

            var newScaleW = this.ImgROIWidth * this.scaleFactorW;
            var newScaleH = this.ImgROIHeight * this.scaleFactorH;
            // calculate the new scale

            var newScaleX = this.scaleX - (newScaleW - this.scaleW) / 2;
            var newScaleY = this.scaleY - (newScaleH - this.scaleH) / 2;
            // calculate a new x and Y for the image to maintain  view

            this.scaleX = newScaleX;
            this.scaleY = newScaleY;
            this.scaleW = newScaleW;
            this.scaleH = newScaleH;
        };

        this.getScaleX = function() {
            return this.scaleX;
        };
        this.getScaleY = function() {
            return this.scaleY;
        };
        this.getScaleW = function() {
            return this.scaleW;
        };
        this.getScaleX = function() {
            return this.scaleH;
        };
        this.getImgWidth = function() {
            return this.imgW;
        };
        this.getImgHeight = function() {
            return this.imgH;
        };
        this.getDspWidth = function() {
            return this.dspW;
        };
        this.getDspHeight = function() {
            return this.dspH;
        };
        // quick accessor functions

        // --------------------------------------------
        // called when the screen extents have changed.
        // --------------------------------------------
        this.setFitToScreenExtents = function(inFitToScreenW, inFitToScreenH) {
            this.dspW = inFitToScreenW;
            this.dspH = inFitToScreenH;

            // reset dependent variables on this display value
            this.scaleFactorW = inFitToScreenW / this.imgW;
            this.scaleFactorH = inFitToScreenH / this.imgH;

            this.scaleW = this.imgW * this.scaleFactorW;
            this.scaleH = this.imgH * this.scaleFactorH;
        };
    } catch (err) {
        var theDetails = "caught: imgOps-" + err.description;
        gFaultHandler.logError(theDetails);
    }
}
