#!/bin/bash
#
#---------------------------------------------
# This script takes:
#
# Argument #1 - The Fastec Production signature.
# Argument #2 - The ".sig" file.
#
# On success, it will return an exit status of 0.
# If the signature doesn't match, it will return
# an exit status of 1.
#---------------------------------------------

# Sanity check the command line.
if [ $# -ne 2 ]; then
    echo "usage: $0 fastec_sig sig_file"
    exit 1
fi

FINGERPRINT=$1
SIGFILE=$2

status=$(gpg --status-fd=4 --trust-model=always --verify "$SIGFILE" 4>&1 >/dev/null 2>&1)

# Return a 0 if we have a match.
if grep -qs "^\\[GNUPG:\\] VALIDSIG $FINGERPRINT " <<< "$status"; then
    exit 0
fi

# No match, so return an error status of 1.
exit 1
