#!/bin/bash

reqspace=$2

# Here's what's going on below:
# - 'df' get a list of all drives and the usages.
# - 'grep' gets the one line we're interested in.
# - 'sed' compress all the space to a single space.
# - 'cut' grabs the one column/field we're interested in.
AVAIL=`df | grep $1 | sed 's/\s\s*/ /g' | cut -d' ' -f4`

# Make sure there is a value.
if [ "$AVAIL" == "" ];
then
	AVAIL=0;
fi

# Now see if the space available is less than
# what we're asking for.
if [ $AVAIL -lt $reqspace ];
then
	exit 0;
else
	exit 1;
fi

