/* Register Definitions for gige_msg.h Created on 2018-7-13 11:21:35 */
/* @file gige_msg.js 
 * @brief Translation of register defines from gige_msg.h into javascript file. 
 * 
 * The gige_msg.h is the header file which lays out details 
 * of the GigE registers. It is used by both the  
 * CameraServer Daemon and through a link by the 
 * libraries used by the web application. 
 * 
 * Copyright 2015 (c) Fastec Imaging as an unpublished work.  
 * All Rights Reserved. 
 * 
 * The information contained herein is confidential property of 
 * Fastec Imaging. The use, copying, transfer or disclosure of such 
 * information is prohibited except by express written agreement 
 * with Fastec Imaging. 
 */

// The overall register manager.
var gRegs = new fastecRegs();

function fastecRegs() {
    ///*!
    // * @file gige_msg.h
    // * @brief Defines GIGE FCP and FSP message structures and definiations.
    // *
    // * This is the header file which lays out details
    // * of the GigE messages. It is used by both the
    // * CameraServer Daemon and through a link by the
    // * libraries used by the workstation application.
    // *
    // * Copyright 2010 (c) Fastec Imaging as an unpublished work.
    // * All Rights Reserved.
    // *
    // * The information contained herein is confidential property of
    // * Fastec Imaging. The use, copying, transfer or disclosure of such
    // * information is prohibited except by express written agreement
    // * with Fastec Imaging.
    // */
    //#ifdef __cplusplus
    //extern "C"
    //{
    //#endif
    //
    //#ifndef GIGE_MSG_H
    //
    //#include <stdint.h>
    //
    ////--------------------------------------------------------------------
    //// Constant, Typedefs and Macros
    ////--------------------------------------------------------------------
    //
    //// Versions of various components
    //#define FPGA_VERSION( major, minor, patch)		((uint32_t)(((major)<<24) | ((minor)<<16) | (patch)))
    //#define FIRMWARE_VERSION( major, minor, patch)		((uint32_t)(((major)<<16) | ((minor)<<8) | (patch)))
    //#define CURRENT_FPGA_VERSION	FPGA_VERSION(0x0,0x1,0xC7)
    //
    //#ifndef FV_MAJ
    //#define CURRENT_FIRMWARE_VERSION    FIRMWARE_VERSION(0xFF, 0xFF, 0xFF)
    //#else
    //#define CURRENT_FIRMWARE_VERSION    FIRMWARE_VERSION(FV_MAJ,FV_MIN,FV_PATCH)
    //#endif
    //
    this.UDP_BROADCAST = "255.255.255.255";
    //
    this.FCP_REG_SIZE = 4; //!< How many bytes is the address for a register
    this.FCP_REG_DATA_SIZE = 4; //!< How many bytes is data for a register
    this.FCP_MSG_HDR_SIZE = 8; //!< FCP message header size
    this.FCP_MSG_DATA_SIZE = 540; //!< so that the upd messages is less than 576
    this.GIGE_SERVER_UDP_PORT = 3956; //!< UDP port for the control protocol
    this.GIGE_FSP_UDP_PORT = 3957; //!< UDP port for the streaming protocol
    this.GIGE_REQ_CODE = 0x42; //!< mandatory code on all FCP messages
    //
    this.GIGE_MAX_PARTITIONS = 16; // maximum number of partitions, can't imagine needing more
    //
    ////===================================================
    //// Header Flags
    ////===================================================
    //
    //// Flags for use in the header
    this.GIGE_FLAG_MUST_ACK_BE = 0x1; //!< high bit, bits are reversed
    this.GIGE_FLAG_ALLOW_BROADCAST_BE = 0x10; //!< bit 3 reversed
    this.GIGE_FLAG_BROADCAST_ACK_BE = 0x8; //!< should the camera server broadcast the ack
    //
    ////===================================================
    //// Message codes
    ////===================================================
    //
    ////! Message codes for FCP messages.
    this.GIGE_MSG_DISCOVERY_CMD = 0x2;
    this.GIGE_MSG_DISCOVERY_ACK = 0x3;
    this.GIGE_MSG_FORCEIP_CMD = 0x4;
    this.GIGE_MSG_FORCEIP_ACK = 0x5;
    this.GIGE_MSG_PACKETRESEND_CMD = 0x40;
    this.GIGE_MSG_READREG_CMD = 0x80;
    this.GIGE_MSG_READREG_ACK = 0x81;
    this.GIGE_MSG_WRITEREG_CMD = 0x82;
    this.GIGE_MSG_WRITEREG_ACK = 0x83;
    this.GIGE_MSG_READMEM_CMD = 0x84;
    this.GIGE_MSG_READMEM_ACK = 0x85;
    this.GIGE_MSG_WRITEMEM_CMD = 0x86;
    this.GIGE_MSG_WRITEMEM_ACK = 0x87;
    this.GIGE_MSG_PENDING_ACK = 0x88;
    this.GIGE_MSG_EVENT_CMD = 0xc0;
    this.GIGE_MSG_EVENT_ACK = 0xc1;
    this.GIGE_MSG_EVENTDATA_CMD = 0xc2;
    this.GIGE_MSG_EVENTDATA_ACK = 0xc3;
    this.GIGE_MSG_ACTION_CMD = 0xc4;
    this.GIGE_MSG_ACTION_ACK = 0xc5;
    //
    ////===================================================
    //// Offsets and Lengths
    ////===================================================
    //
    ////! Offsets into the data for GIGE messages. Note that the B (byte), W(word),
    ////! or L(long) refer to which view of the data it is refering to.
    ////! Discovery Ack Message
    this.GIGE_DSC_ACK_PROTO_VER_W = 0;
    this.GIGE_DSC_ACK_MAC_B = 10;
    this.GIGE_DSC_ACK_MAC_B_LEN = 6;
    this.GIGE_DSC_ACK_MODE_L = 1;
    this.GIGE_DSC_ACK_IP_OPT_L = 4;
    this.GIGE_DSC_ACK_IP_CUR_L = 5;
    this.GIGE_DSC_ACK_IP_L = 9;
    this.GIGE_DSC_ACK_SUBNET_L = 13;
    this.GIGE_DSC_ACK_GATEWAY_L = 17;
    this.GIGE_DSC_ACK_VENDOR_B = 72;
    this.GIGE_DSC_ACK_VENDOR_B_LEN = 32;
    this.GIGE_DSC_ACK_MODEL_B = 104;
    this.GIGE_DSC_ACK_MODEL_B_LEN = 32;
    this.GIGE_DSC_ACK_VERSION_B = 136;
    this.GIGE_DSC_ACK_VERSION_B_LEN = 32;
    this.GIGE_DSC_ACK_MAN_INFO_B = 168;
    this.GIGE_DSC_ACK_MAN_INFO_B_LEN = 48;
    this.GIGE_DSC_ACK_SERIAL_B = 216;
    this.GIGE_DSC_ACK_SERIAL_B_LEN = 16;
    this.GIGE_DSC_ACK_USER_NAME_B = 232;
    this.GIGE_DSC_ACK_USER_NAME_B_LEN = 16;
    this.GIGE_DSC_ACK_B_LEN = 248;
    //
    ////! FORCEIP_CMD
    this.GIGE_FORCEIP_REQ_B_LEN = 56;
    this.GIGE_FORCEIP_REQ_MAC_B = 2;
    this.GIGE_FORCEIP_REQ_IP_L = 5;
    this.GIGE_FORCEIP_REQ_SUBNET_L = 9;
    this.GIGE_FORCEIP_REQ_GATEWAY_L = 13;
    this.GIGE_FORCEIP_ACK_B_LEN = 0;
    //
    ////! READREG_CMD
    this.GIGE_READREG_REQ_B_LEN = 4;
    this.GIGE_READREG_ACK_B_LEN = 4;
    //
    ////! WRITEREG_CMD
    this.GIGE_WRITEREG_REQ_B_LEN = 8;
    this.GIGE_WRITEREG_ACK_B_LEN = 4;
    //
    ////! READMEM_CMD
    this.GIGE_READMEM_REQ_B_LEN = 8;
    this.GIGE_READMEM_REQ_ADDR_L = 0;
    this.GIGE_READMEM_REQ_COUNT_W = 3;
    this.GIGE_READMEM_B_LEN = this.FCP_MSG_DATA_SIZE - 4;
    this.GIGE_READMEM_ACK_ADDR_L = 0;
    this.GIGE_READMEM_ACK_DATA_B = 4;
    this.GIGE_READMEM_ACK_DATA_L = 1;
    //
    ////! WRITEMEM_CMD
    this.GIGE_WRITEMEM_REQ_ADDR_L = 0;
    this.GIGE_WRITEMEM_REQ_DATA_B = 4;
    this.GIGE_WRITEMEM_ACK_B_LEN = 4;
    this.GIGE_WRITEMEM_ACK_COUNT_W = 1;
    this.GIGE_WRITEMEM_B_LEN = this.GIGE_READMEM_B_LEN;
    this.GIGE_WRITEMEM_ADDR_LEN = 4;
    //
    ////! EVENT_CMD & EVENTDATA_CMD
    this.GIGE_EVENT_B_LEN = 16;
    this.GIGE_EVENTDATA_B_LEN = 20;
    //
    ////===================================================
    //// Timeout
    ////===================================================
    //
    this.GIGE_HEARTBEAT_TIMEOUT = 5000; // 5 seconds
    //
    ////===================================================
    //// Status Codes
    ////===================================================
    //
    this.GEV_STATUS_SUCCESS = 0x0000;
    this.GEV_STATUS_PACKET_RESEND = 0x0100;
    this.GEV_STATUS_NOT_IMPLEMENTED = 0x8001;
    this.GEV_STATUS_INVALID_PARAMETER = 0x8002;
    this.GEV_STATUS_INVALID_ADDRESS = 0x8003;
    this.GEV_STATUS_ACCESS_DENIED = 0x8006;
    this.GEV_STATUS_BUSY = 0x8007;
    this.GEV_STATUS_PACKET_NOT_AVAIL = 0x800c;
    this.GEV_STATUS_DATA_OVERRUN = 0x800d;
    this.GEV_STATUS_INVALID_HEADER = 0x800e;
    this.GEV_STATUS_WRONG_CONFIG = 0x800f;
    this.GEV_STATUS_ERROR = 0x8fff;
    //
    ////===================================================
    ////  Registers Currently used
    ////===================================================
    //
    ////! FCP registers used at this point.
    this.GIGE_REG_GIGE_VER = "0x0000";
    this.GIGE_REG_DEV_MODE = "0x0004";
    this.GIGE_REG_MAC_HIGH = "0x0008";
    this.GIGE_REG_MAC_LOW = "0x000C";
    this.GIGE_REG_IP_CFG = "0x0010";
    this.GIGE_REG_IP_CUR_CFG = "0x0014";
    this.GIGE_REG_IP_ADDR = "0x0024";
    this.GIGE_REG_SUBNET_MASK = "0x0034";
    this.GIGE_REG_DEF_GATEWAY = "0x0044";
    this.GIGE_REG_MAN_NAME = "0x0048";
    this.GIGE_REG_MAN_NAME_B_LEN = "32";
    this.GIGE_REG_MODEL_NAME = "0x0068";
    this.GIGE_REG_MODEL_NAME_B_LEN = "32";
    this.GIGE_REG_DEVICE_VER = "0x0088";
    this.GIGE_REG_DEVICE_VER_B_LEN = "32";
    this.GIGE_REG_MAN_INFO = "0x00A8";
    this.GIGE_REG_MAN_INFO_B_LEN = "48";
    this.GIGE_REG_SERIAL_NUM = "0x00D8";
    this.GIGE_REG_SERIAL_NUM_B_LEN = "16";
    this.GIGE_REG_USER_DEF_NAME = "0x00E8";
    this.GIGE_REG_USER_DEF_NAME_B_LEN = "16";
    this.GIGE_REG_XML_URL_1 = "0x0200";
    this.GIGE_REG_XML_URL_B_LEN = "512";
    this.GIGE_REG_XML_URL_2 = "0x0400";
    this.GIGE_REG_NUM_NIC = "0x0600";
    this.GIGE_REG_PERSIST_IP = "0x064C";
    this.GIGE_REG_PERSIST_SUBNET = "0x065C";
    this.GIGE_REG_PERSIST_GATEWAY = "0x066C";
    this.GIGE_REG_NUM_MSG_CHAN = "0x0900";
    this.GIGE_REG_NUM_STREAMS = "0x0904";
    this.GIGE_REG_MCSP = "0x0930";
    this.GIGE_REG_FCP_CAP = "0x0934";
    this.GIGE_REG_HEARTBEAT = "0x0938";
    //// Unused 0x093C-0x094C, was GIGE_REG_TIMESTAMP_*
    this.GIGE_REG_CCP = "0x0A00";
    this.GIGE_REG_MCP = "0x0B00";
    this.GIGE_REG_MCDA = "0x0B10";
    this.GIGE_REG_MCTT = "0x0B14";
    this.GIGE_REG_MCRC = "0x0B18";
    this.GIGE_REG_SCP0 = "0x0D00";
    this.GIGE_REG_SCPS0 = "0x0D04";
    this.GIGE_REG_SCPD0 = "0x0D08";
    this.GIGE_REG_SCDA0 = "0x0D18";
    //
    this.GIGE_REG_FIRMWARE_VER = "0xA004";
    this.GIGE_REG_TIMEZONE = "0xA01C";
    this.GIGE_TIMEZONE_LEN = 64; // Maximum length we allow for a time zone string
    this.GIGE_REG_SENSOR_WIDTH = "0xA020";
    this.GIGE_REG_SENSOR_HEIGHT = "0xA024";
    this.GIGE_REG_TIMEOFDAY = "0xA028";
    this.GIGE_REG_NTP_SERVER = "0xA02C";
    this.GIGE_NTP_SERVER_LEN = 64;
    //
    this.GIGE_REG_SESSION_LENGTH = "0xA030";
    //
    //// The absolute maximum sensor dimensions control the maximum size that can be set
    //// regardless of circumstances. This does not change after startup, unlike the
    //// GIGE_REG_SENSOR_WIDTH and GIGE_REG_SENSOR_HEIGHT values, which can change with
    //// sensor options and bit mode.
    this.GIGE_REG_ABS_SENSOR_WIDTH = "0xA034";
    this.GIGE_REG_ABS_SENSOR_HEIGHT = "0xA038";
    //
    //// User preferences that are common across multiple GUIs.
    this.GIGE_REG_PREFERENCES = "0xA03C";
    //// Bit definitions and masks for GIGE_REG_PREFERENCES.
    this.GIGE_PREF_AUTOPLAY = 1 << 0; // Set to enable autoplay after review.
    this.GIGE_PREF_ARM_IN_OVERWRITE = 1 << 1; // Set to act on ARM_IN even if it will
    //// overwrite and lose an existing recording.
    //
    //
    //// Enable/Disable autosave mode on the camera.
    ////
    //// Writing the GIGE_REG_AUTOSAVE register, you only set
    //// or clear the enable bit. The others are don't-care
    //// on writes.
    this.GIGE_REG_AUTOSAVE = "0xA050";
    //
    //// ---------------------------------------------------------
    this.GIGE_AUTOSAVE_COUNT_MASK = 0xff;
    this.GIGE_AUTOSAVE_TOTAL_SHIFT = 8;
    //
    //// b0:7[ro] - number of available partitions.
    //#define GIGE_AUTOSAVE_AVAIL_COUNT( x )		((x) & GIGE_AUTOSAVE_COUNT_MASK )
    //// b8:15[ro] - total number of partitions we can use.
    //#define GIGE_AUTOSAVE_TOTAL_COUNT( x )		(((x) >> GIGE_AUTOSAVE_TOTAL_SHIFT ) & GIGE_AUTOSAVE_COUNT_MASK )
    //// b16:26 - unused.
    //// b27[ro] - set if user wants to operate in autosave mode (but not implemented yet).
    this.GIGE_AUTOSAVE_USER_ENABLE = 1 << 27;
    //// b28[ro] - set if autosave manager is still running.
    //// If AVAIL_COUNT() < TOTAL_COUNT(), so there are dirty partitions, GUI can use this to find out
    //// if the saves are still going on versus terminated by cancel or error.
    this.GIGE_AUTOSAVE_SAVING = 1 << 28;
    //// b29[wo] - autosave manager needs to update its queues.
    this.GIGE_AUTOSAVE_QUEUE_UPDATE = 1 << 29;
    //// b30[ro] - overlap supported.
    this.GIGE_AUTOSAVE_OVERLAP = 1 << 30;
    //// b31[rw] - enable/disable autosave.
    this.GIGE_AUTOSAVE_DISABLE = 0;
    this.GIGE_AUTOSAVE_ENABLE = 1 << 31;
    //// ---------------------------------------------------------
    //
    //// Define the user's frame range registers for saving.
    //// These can be used by a UI to retain the save range set by a user, particularly for
    //// autosaving. The camera server is just a repository for them, reloading them from the register
    //// save file on reboot, and setting them to the full range any time there is a change
    //// in the session frame count. The actual save process still uses the dynamic values
    //// GIGE_REG_SAVE_START_NUM and GIGE_REG_SAVE_END_NUM.
    //// Without these, the GUI tries to use SAVE_START_NUM and SAVE_END_NUM to populate the
    //// Autosave and Save All dialogs but those are still set to the values last used for a
    //// regular save.
    this.GIGE_REG_USER_SAVE_START_NUM = "0xA054";
    this.GIGE_REG_USER_SAVE_END_NUM = "0xA058";
    //
    //
    this.GIGE_REG_WIDTH = "0xD300";
    this.GIGE_REG_HEIGHT = "0xD304";
    //
    //// Change the state of the camera. This is a write only register which affects the camera state.
    //// Valid states to change to are 1=unarmed live video, 2=armed live view,
    //// 4=triggered live view, 8=review mode, 16=snapshot, 64=dearm.
    //// If moving from armed or triggered to unarmed live video
    //// the partition which was in process is invalidated and its state goes back to PARTITION_EMPTY.
    //// 1 moves the camera to unarmed live video, 2 the camera is armed,
    //// 4 triggers the camera either from unarmed or armed. 8 puts the camera into review mode which is only
    //// valid if the camera has multiple partitions or recording is complete on a partition.
    //// 64 takes the camera out of the armed or triggered state, retaining what was captured so far.
    //// #defines for the states are below.
    this.GIGE_REG_CHANGE_CAMERA_STATE = "0xD310";
    //
    //// Registers to control remote streaming, eveything should be setup before writing this register.
    //// Write to this register to start streaming.
    ////
    //// The behavior is a little different depending upon if streaming is happening on live or on recorded video:
    //// - If live then staring the stream will continue until the steam is stopped.
    //// - If streaming recorded video either a single frame can be streamed by setting GIGE_REG_STREAM_START_NUM and
    ////   GIGE_REG_STREAM_END_NUM to the same value, or a range of frames can be streamed by setting them to different
    ////   values video this register will self clear once the requested frames are streamed.
    this.GIGE_REG_STREAM_CONTROL = "0xD314";
    this.GIGE_STREAM_STOP = 0x00;
    this.GIGE_STREAM_LIVE = 0x01;
    this.GIGE_STREAM_RECORDED = 0x02;
    this.GIGE_STREAM_DOWNLOAD = 0x03;
    this.GIGE_STREAM_SINGLESTEP = 0x04;
    this.GIGE_STREAM_GET_FILE = 0x05;
    this.GIGE_STREAM_SLAVE_ENABLE = 0x06;
    this.GIGE_STREAM_RAW_METADATA = 0x07;
    this.GIGE_STREAM_SESSION = 0x08;
    this.GIGE_STREAM_PAUSE = 0x10;
    this.GIGE_STREAM_RESUME = 0x20;
    this.GIGE_STREAM_CONTROL_MASK = 0xf0;
    //
    //// Use this register to specify the file/folder to stream when GIGE_REG_STREAM_CONTROL is set
    //// to GIGE_STREAM_GET_FILE.
    this.GIGE_REG_STREAM_FILEPATH = "0xD318";
    this.GIGE_STREAM_FILEPATH_LEN = 512;
    //
    //// Start and stop local shared-memory stream for use by on-camera client.
    this.GIGE_REG_LOCALSTREAM_CONTROL = "0xD400";
    this.GIGE_LOCALSTREAM_STOP = 0x00; // Stop, thread not running.
    this.GIGE_LOCALSTREAM_SINGLESTEP = 0x01; // Update one frame as changes are detected
    this.GIGE_LOCALSTREAM_PLAYBACK = 0x02; // Play slaved to DCM
    this.GIGE_LOCALSTREAM_DOWNLOAD = 0x03; // Download using save parameters
    this.GIGE_LOCALSTREAM_LIVE = 0x04; // Live view.
    //
    //// If you need to retry a file download, then set this to the file "number", so if there
    //// were 5 files (1..5), and you needed to retry the 3rd one, set this register to "3".
    //// Otherwise, set it to 0 to get everything associated with GIGE_REG_STREAM_FILEPATH.
    ////
    //// For a single file, say a CAP file or an AVI, set GIGE_STREAM_RETRY_OFFSET bit or'd
    //// with the absolute (0-based) "chunk" you want retransmitted. For example, to retransmit
    //// the first "chunk" you would write 0x80000000. To transmit the second "chunk", write 0x80000001.
    this.GIGE_REG_STREAM_RETRY = "0xD518";
    this.GIGE_STREAM_RETRY_OFFSET = 1 << 31; // Used to differentiate between file retries and block retries.
    //
    this.GIGE_REG_OFFSET_X = "0xE81C";
    this.GIGE_REG_OFFSET_Y = "0xE820";
    this.GIGE_REG_FRAME_RATE = "0xE824";
    this.GIGE_REG_SHUTTER_SPEED = "0xE82C";
    this.GIGE_REG_MAX_FRAME_RATE = "0xE830";
    this.GIGE_REG_MAX_SHUTTER_SPEED = "0xE838";
    this.GIGE_REG_MIN_SHUTTER_SPEED = "0xE83C";
    //
    //// The sensor's VREFCOL setting is adjusted automatically during the calibration process
    //// for Column FPN, or it can be overridden directly by writing this register.
    //// Accepted values are 0-0xFF but typical values are 0x40-0xC0.
    this.GIGE_REG_SENSOR_VREFCOL = "0xE840";
    //
    //// The register GIGE_REG_SENSOR_GAIN contains the sensor gain values.
    //// The interface will accept any values but will adjust the value to a legal setting.
    //// NOTE: For LUPA1300: The valid range is 100-400 with breaks every 50.
    ////       If a value outside that range is passed it it will set it to the closest value.
    ////       This is the PGA (Programmable Gain Amplifiers), 3 bits that go into the
    ////       afemode (Analog Front End mode) register.
    ////	 For LINCE5M: The valid values are 1, 2, and 4 with an optional "IMMEDIATE" flag
    ////	 that says we should go ahead and restart the sensor now.
    this.GIGE_REG_SENSOR_GAIN = "0xE844";
    this.GIGE_SENSOR_GAIN_IMMEDIATE = 0x80000000; // Set this flag to immediately restart the sensor.
    //
    //// This is an offset used for black pixels when using Column FPN.
    //// Accepted values are 0-0xFF but typical values are 0x10-0x80.
    this.GIGE_REG_SENSOR_BLACKCAL = "0xE848";
    //
    //// Sensor binning and subsampling options. Available options depend on the sensor.
    this.GIGE_REG_SENSOR_OPTIONS = "0xE84C";
    this.GIGE_SENSOPT_BIN_MASK = 0x000000ff; // Binning option mask
    this.GIGE_SENSOPT_BIN_SHIFT = 0; // Anafocus binning is ( 1, 2, 4 ) << 0
    this.GIGE_SENSOPT_SUBS_MASK = 0x0000ff00; // Subsampling option mask
    this.GIGE_SENSOPT_SUBS_SHIFT = 8; // AnaFocus subsampling is ( 1, 2, 4 ) << 8
    this.GIGE_SENSOPT_HDR_MASK = 0x00030000; // Sensor HDR options.
    this.GIGE_SENSOPT_INTERNAL_0 = 0x10000000; // Sensor-specific internal setting.
    //// Lince: use the slower sensor clock mode FM6.
    //
    //// This register reflects the state of the camera. Note that different partitions could be in different state
    //// but this reflects what the LCD is doing.
    //// state of camera 0=idle(i.e. startup), 1=unarmed live video, 2=armed live view,
    //// 4=triggered live view, 8=review mode
    //// #defines for the states are below
    this.GIGE_REG_CAMERA_STATE = "0xE854";
    //
    //// Write only register to reset all the registers to factory value. Write any value into the register
    this.GIGE_REG_RESET_TO_FACTORY = "0xE874";
    //
    this.GIGE_REG_FRAME_SIZE = "0xE8A8";
    this.GIGE_REG_NUM_FRAMES = "0xE8C0";
    this.GIGE_REG_SYNC_DELAY = "0xE8FC";
    this.GIGE_REG_SYNC_IN_ENABLE = "0xE900";
    this.GIGE_REG_SYNC_OUT_SELECT = "0xE904";
    this.GIGE_REG_SYNC_ARM_POLARITY = "0xE908";
    this.GIGE_REG_SYNC_IN_POLARITY = "0xE90C";
    this.GIGE_REG_EXT_TRIG_POLARITY = "0xE910";
    this.GIGE_REG_EXT_TRIG_ENABLE = "0xE914";
    this.GIGE_REG_STREAM_SEQ_START = "0xE918";
    this.GIGE_REG_STREAM_START_NUM = "0xE924";
    this.GIGE_REG_STREAM_END_NUM = "0xE928";
    this.GIGE_REG_STREAM_FRAME_INTERVAL = "0xE92C";
    this.GIGE_REG_STREAM_FRAME_DELAY = "0xE930";
    this.GIGE_REG_BOOTLOADER_VER = "0xE948";
    this.GIGE_REG_SENSOR_VER = "0xE94C";
    this.GIGE_REG_FPGA_VER = "0xE950";
    this.GIGE_REG_ARM_IN_ENABLE = "0xE954";
    this.GIGE_REG_ARM_IN_POLARITY = "0xE958";
    this.GIGE_REG_ARM_OUT_SELECT = "0xE95C";
    this.GIGE_REG_TRIG_OUT_SELECT = "0xE960";
    //
    this.GIGE_SENSOR_VER_LEN = 16; // length of the sensor version register
    //
    //// Bit definitions and masks for GIGE_REG_STREAM_FRAME_INTERVAL.
    this.GIGE_STREAM_FORWARD = 0;
    this.GIGE_STREAM_REVERSE = 1 << 31;
    this.GIGE_STREAM_SINGLE = 0;
    this.GIGE_STREAM_LOOP = 1 << 30;
    this.GIGE_STREAM_INTERVAL_MASK = 0x0fffffff;
    //
    //// Registers used for review playback control.
    this.GIGE_REG_PB_CONTROL = "0xB800";
    this.GIGE_PBC_ENABLE = 1 << 0; // Set if playback is enabled
    this.GIGE_PBC_REVERSE = 1 << 1; // Set to play in reverse
    this.GIGE_PBC_SINGLE_START = 1 << 4; // [RO] Indicates we are in single playback mode (PBC_ENABLE will be 0).
    this.GIGE_PBC_SINGLE_ABORT = 1 << 5; // Set to stop single playback mode.
    this.GIGE_PBC_INTERVAL_SHIFT = 16; // Shift for playback frame interval
    this.GIGE_PBC_INTERVAL_MASK = 0xfff << 16; // Mask for playback frame interval
    this.GIGE_REG_PB_STATUS = "0xB804";
    this.GIGE_PBS_BUSY = 1 << 0; // Set if playback is running.
    this.GIGE_PBS_SINGLEMODE = 1 << 1; // Set if playback is running.
    this.GIGE_REG_PB_FRAME_PERIOD = "0xB808";
    ////Retired 0xB80C was GIGE_REG_PB_PART_START_PTR
    ////Retired 0xB810 was GIGE_REG_PB_PART_END_PTR
    this.GIGE_REG_PB_CUT_IN_FRAME = "0xB814";
    this.GIGE_REG_PB_CUT_OUT_FRAME = "0xB818";
    this.GIGE_REG_PB_START_FRAME = "0xB81C";
    ////Retired 0xB820 was GIGE_REG_PB_FRAME_BUF_SIZE
    this.GIGE_REG_PB_LAST_FRAME = "0xB824";
    //
    ////===================================================
    ////  General Partition Information
    ////===================================================
    //
    //// Partition information, each partition is the same size, unless we are ROC mode which is not
    //// implemented yet.
    //// GIGE_REG_FRAME_SIZE and GIGE_REG_NUM_FRAMES are above
    this.GIGE_REG_MAX_PART = "0xC000";
    this.GIGE_REG_NUM_PART = "0xC004";
    this.GIGE_REG_ACTIVE_PART = "0xC008";
    //
    //// Partition size in quadwords(16 bytes), if zero then partitions are of different sizes. Check
    //// for the specific partition.
    this.GIGE_REG_PART_SIZE = "0xC010";
    this.GIGE_REG_MEM_SIZE = "0xC014";
    //
    this.GIGE_REG_MEM_SIZE_RESERVED = "0xC018";
    this.GIGE_REG_PART_SIZE_RESERVED = "0xC01C";
    //
    this.GIGE_REG_BIT_MODE = "0xC020";
    //
    //// The following register is used to control both the sensor on-chip FPN and the FPGA's fpn.
    //// Setting any bit to true causes that operation to take place.
    //// Note: that both the on-chip FPN and the FPGA's FPN can
    //// be turned off but turning them on is mutually exclusive. The enable bits are sticky which means that they
    //// can be read back to tell if that FPN is turned on. All other bits are self clearing.
    //// Note: Only one bit can be set at a time, any other set bits will be ignored.
    //// Note: For factory calibrate to work as expected the system should have had the default registers restored.
    this.GIGE_REG_FPN = "0xC028";
    this.GIGE_FPN_SENSOR_ENABLE_MASK = 0x0001; // Use sensor built-in FPN.
    this.GIGE_FPN_FPGA_ENABLE_MASK = 0x0004; // Use FPGA's pixel FPN.
    this.GIGE_FPN_FPGA_UNCALIBRATED = 0x0010; // Read-only, set if calibration is needed.
    this.GIGE_FPN_FPGA_CALIBRATE_MASK = 0x0020;
    this.GIGE_FPN_FPGA_FAC_CALIBRATE_MASK = 0x0040;
    this.GIGE_FPN_FPGA_LOAD_MASK = 0x0080; // Obsolete, to be removed.
    this.GIGE_FPN_CALIBRATE_MANUAL = 0x0100; // Use manual calibration options.
    //
    this.GIGE_REG_SENSOR_DAC = "0xC02C";
    this.GIGE_REG_SENSOR_DAC_MASK = "0xFF";
    //
    ////===================================================
    //// Record settings not in FI Series 3 & HiSpec section
    ////===================================================
    //
    //// Any write to GIGE_REG_LUT resets the file position for readmem/writemem of GIGE_REG_LUT_DATA.
    this.GIGE_LUT_MASK = 0x0f; // Mask for current LUT number
    this.GIGE_LUT_NONE = 0; // No user LUT is in effect
    this.GIGE_LUT_MAX = 5; // Allow LUTs 1-5
    this.GIGE_LUT_DEFER = 0x80000000; // Don't change LUT hardware to this LUT #.
    this.GIGE_REG_LUT = "0xC030";
    //
    this.GIGE_MIN_BRIGHTNESS = 0; // Minimum value for brightness.
    this.GIGE_MAX_BRIGHTNESS = 200; // Maximum value for brightness.
    this.GIGE_DEFAULT_BRIGHTNESS = 100; // Default value for brightness.
    this.GIGE_REG_BRIGHTNESS = "0xC034";
    this.GIGE_MIN_CONTRAST = 0; // Minimum value for contrast.
    this.GIGE_MAX_CONTRAST = 200; // Maximum value for contrast.
    this.GIGE_DEFAULT_CONTRAST = 100; // Default value for contrast.
    this.GIGE_REG_CONTRAST = "0xC038";
    //
    //// When setting the gamma, the new value is in the lo-word. When setting the
    //// default gamma, the gamma value is in the lo-word and the GIGE_GAMMA_SET_DEFAULT
    //// bit is asserted.
    ////
    //// When you READ the gamma register, it returns the default value in the hi-word
    //// and the current setting in the lo-word.
    this.GIGE_MIN_GAMMA = 10; // Minimum value for gamma.
    this.GIGE_MAX_GAMMA = 500; // Maximum value for gamma.
    this.GIGE_DEFAULT_GAMMA = 100; // Default value for gamma.
    this.GIGE_GAMMA_SET_DEFAULT = 1 << 31; // Indicate that the gamma is to be used as the default value.
    this.GIGE_REG_GAMMA = "0xC03C";
    //
    this.GIGE_REG_RED = "0xC040";
    this.GIGE_REG_GREEN = "0xC044";
    this.GIGE_REG_BLUE = "0xC048";
    this.GIGE_DEFAULT_RGB_GAIN = 0x100; // default red/blue/green color
    this.GIGE_REG_RGB_MASK = "0xFF";
    this.GIGE_REG_LOW_LIGHT_ENABLE = "0xC04C";
    this.GIGE_REG_LOW_LIGHT_SHUTTER = "0xC050";
    this.GIGE_REG_MIN_WIDTH = "0xC054";
    this.GIGE_REG_MIN_HEIGHT = "0xC058";
    //
    //// The following register defines the reset white balance selection. They are listed below. If one of the
    //// preset white balance values is selected then the camera server will do its magic and set the appropriate
    //// registers within the FPGA for the MAXTRIX_COEFFICIENTS and the WHITE_BALANCE_RED,GREEN,BLUE registers.
    //// If custom is selected then the client app is responsible for setting those registers themselves. Note that
    //// trying to set those registers if this register is set to a standard value will be rejected.
    //// The final option is to set the GIGE_REG_GENERATE_CUSTOM_WB which will allow the user to generate a
    //// custom white balance using a white (or grey) card. Everything here is still TBD on the camera side.
    this.GIGE_WHITE_BAL_DAYLIGHT = 0;
    this.GIGE_WHITE_BAL_TUNGSTEN = 1;
    this.GIGE_WHITE_BAL_FLOURESCENT = 2; // For backward compatibility.
    this.GIGE_WHITE_BAL_FLUORESCENT = 2;
    this.GIGE_WHITE_BAL_NORMAL = 3;
    this.GIGE_WHITE_BAL_CUSTOM = 4;
    this.GIGE_REG_WHITE_BAL = "0xC05C";
    //
    //// Write only register causes the camera to reset. Write GIGE_RESET_FOR_UPDATE
    //// if you want to have the camera reboot to the SDCard (and presumably start
    //// an update). Write GIGE_RESET_POWER_DOWN to shutdown the camera.
    this.GIGE_RESET_FOR_UPDATE = 0x5555;
    this.GIGE_RESET_POWER_DOWN = 0xaaaa;
    this.GIGE_REG_RESET_CAMERA = "0xC060";
    //
    //// Registers needed so clients can determine maximum ROI's & FR
    this.GIGE_REG_SENSOR_TYPE = "0xC064";
    //
    this.GIGE_MEDIA_SDCARD = 1 << 0;
    this.GIGE_MEDIA_SSD = 1 << 1;
    this.GIGE_MEDIA_USB = 1 << 2;
    this.GIGE_MEDIA_AVAIL_MASK = 0x07;
    this.GIGE_MEDIA_EXISTS_SDCARD = 1 << 4;
    this.GIGE_MEDIA_EXISTS_SSD = 1 << 5;
    this.GIGE_MEDIA_EXISTS_USB = 1 << 6;
    this.GIGE_MEDIA_EXISTS_MASK = 0x70;
    this.GIGE_MEDIA_USB_GADGET = 1 << 30; //!< Currently connected to host by USB.
    this.GIGE_REG_AVAIL_MEDIA = "0xC068";
    //
    this.GIGE_FORMAT_FAT32 = 1 << 8;
    this.GIGE_FORMAT_EXT2 = 1 << 9;
    this.GIGE_FORMAT_FILR = 1 << 10; // Fastec Imaging LR format.
    this.GIGE_FORMAT_SANITIZE = 1 << 11;
    this.GIGE_FORMAT_MASK = 0xf << 8;
    //
    this.GIGE_FORMAT_DONE = 1 << 31;
    this.GIGE_REG_FORMAT_MEDIA = "0xC06C";
    //
    //// wo reg to tell the camera server to do something with its registers
    //// a value of 1 will cause it to flush its registers to NAND
    //// a value of 2 will cause it to restore its registers from NAND if the camera state is IDLE
    this.GIGE_REG_CS_REGS = "0xC070";
    this.GIGE_CS_REGS_FLUSH = 1; //!< Flush the registers to the file.
    this.GIGE_CS_REGS_LOAD = 2; //!< Load the registers from the file.
    //
    //// Write-only reg to let the camera server know that the caller would like to receive unsolicited messages.
    //// This should only be used by internal clients. If sign up for notifications write a non zero, if the app no longer wishes to receive
    //// notifications then write a 0. If an app is signing up for notifications it should not close its
    //// socket since that socked is going to used for the notifications.
    this.GIGE_REG_EVENT_NOTIFY = "0xC074";
    this.GIGE_EVENT_NOTIFY_OFF = 0;
    this.GIGE_EVENT_NOTIFY_ON = 1;
    //
    //// ro reg to indicate if the update was successful or not.
    //// 0 - update failed.
    //// 1 - everything went OK.
    this.GIGE_REG_UPDATE_STATUS = "0xC078";
    //
    //// RO register which indicates the actual session size (in SESSION_INCR increments).
    this.GIGE_REG_SESSION_SIZE = "0xC07C";
    //
    ////===================================================
    //// Registers having to do with triggers and syncs.
    ////===================================================
    //
    //// Trigger request position. The high bit says how the rest of the register should be interpreted.
    //// Valid values are 0 for percent based or 1 for frame based. If it's percent based then
    //// values from 0 to 100 are valid for the rest of the register.
    //// If frame based the rest of the register is an actual trigger frame number. In % mode the CS will
    //// be responsible for converting it during the arm process. The default value is % based with a value of 10.
    this.GIGE_TRIGGER_REQ_FRAME_MASK = 0x80000000;
    this.GIGE_TRIGGER_REQ_POS_MASK = 0x7fffffff;
    this.GIGE_REG_TRIGGER_REQ_POS = "0xC080";
    //
    //// Bit patterns for the GIGE_REG_TRIGGER_REQ_POS register.
    //// FIXME We seem to have duplicate definitions.
    this.GIGE_PART_TRIG_FRAMES = 1;
    this.GIGE_PART_TRIG_FRAMES_MASK = 0x7fffffff;
    //
    //// GIGE_REG_EXT_TRIG_ENABLE
    //// External trigger enable is true when bit0 = 1.
    this.GIGE_EXT_TRIG_ENABLE_MASK = 0x01;
    //// The external trigger channel starts at bit4 for channel_0.
    this.GIGE_EXT_TRIG_CHANNEL_SHIFT = 4;
    //
    //// GIGE_REG_EXT_TRIG_POLARITY
    //// External trigger polarity is falling edge when bit0 = 0. It is rising edge
    //// when bit0 = 1.
    this.GIGE_EXT_TRIG_POLARITY_FALLING = 0x0;
    this.GIGE_EXT_TRIG_POLARITY_RISING = 0x1;
    //
    //// GIGE_REG_SYNC_IN_ENABLE
    this.GIGE_SYNC_TYPE_INTERNAL = 0x000;
    this.GIGE_SYNC_TYPE_EXTERNAL = 0x001;
    this.GIGE_SYNC_TYPE_IRIGB = 0x002;
    this.GIGE_SYNC_TYPE_GPS = 0x003;
    this.GIGE_SYNC_TYPE_MASK = 0x00f;
    //
    //// For types other than internal, we need to know if it's 1 pulse-per-frame (0x00)
    //// or 1 pulse-per-second (0x10).
    this.GIGE_SYNC_IN_PPF = 0x010;
    this.GIGE_SYNC_IN_PPS = 0x020;
    this.GIGE_SYNC_IN_PULSE_MASK = 0x0f0;
    //
    //// For 1PPF mode, we also support a divide-down feature. How many sync pulses
    //// do we skip before taking another frame?
    this.GIGE_SYNC_IN_SKIP_MASK = 0xf00;
    this.GIGE_SYNC_IN_SKIP_SHIFT = 8;
    //
    //// The sync-in channel starts at bit16 for channel_0.
    this.GIGE_SYNC_IN_CHANNEL_SHIFT = 16;
    //
    //// GIGE_REG_SYNC_IN_POLARITY
    //// For external SyncIn pulses, we need to know if the pulse is active on the
    //// falling (0x00) or rising (0x01) edge.
    this.GIGE_SYNC_IN_FALLING = 0x00;
    this.GIGE_SYNC_IN_RISING = 0x01;
    this.GIGE_SYNC_IN_POL_MASK = 0x0f;
    //
    //// GIGE_REG_SYNC_IN_TIMING. This returns the number of 125Mhz clocks (FPGA Clocks) between
    //// SyncIn pulses
    this.GIGE_REG_SYNC_IN_TIMING = "0xC084";
    //
    //// GIGE_REG_SYNC_IN_MFR. This returns and stores the master frame rate which the user entered
    this.GIGE_REG_SYNC_IN_MFR = "0xC088";
    //
    //// GIGE_REG_SYNC_OUT_SELECT
    //// If the register is enabled, we need to specify what we're going to send.
    this.GIGE_SYNC_OUT_DISABLE = 0x0000;
    this.GIGE_SYNC_OUT_ENABLE = 0x0001;
    //
    this.GIGE_SYNC_OUT_PPS = 1 << 1;
    this.GIGE_SYNC_OUT_PPF = 2 << 1;
    this.GIGE_SYNC_OUT_IS_SYNC_IN = 3 << 1;
    this.GIGE_SYNC_OUT_MASK = 0x000e;
    //
    this.GIGE_SYNC_OUT_ACTIVE_HIGH = 0x0010;
    this.GIGE_SYNC_OUT_ACTIVE_LOW = 0x0020;
    this.GIGE_SYNC_OUT_INVERT_SYNCIN = 0x0040;
    this.GIGE_SYNC_OUT_PASS_SYNCIN = 0x0080;
    this.GIGE_SYNC_OUT_POLARITY_MASK = 0x00f0;
    //
    this.GIGE_SYNC_OUT_DUTYCYCLE_MASK = 0xff00;
    this.GIGE_SYNC_OUT_DUTYCYCLE_SHIFT = 8;
    this.GIGE_SYNC_OUT_INTEGRATION_PERIOD = 0x0000;
    //
    //// The sync-out channel starts at bit16 for channel_0.
    this.GIGE_SYNC_OUT_CHANNEL_SHIFT = 16;
    //
    //// GIGE_REG_ARM_IN_ENABLE
    this.GIGE_ARM_TYPE_INTERNAL = 0x000;
    this.GIGE_ARM_TYPE_EXTERNAL = 0x001;
    //
    //// The arm-in channel starts at bit4 for channel_0.
    this.GIGE_ARM_IN_CHANNEL_SHIFT = 4;
    //
    //// GIGE_REG_ARM_IN_POLARITY
    //// For external ArmIn pulses, we need to know if the signal is an edge or level
    //// signal, and then whether it is active when falling/low (0x00) or rising/high (0x01).
    this.GIGE_ARM_IN_EDGE_MASK = 1 << 0;
    this.GIGE_ARM_IN_LEVEL_TYPE = 0 << 0;
    this.GIGE_ARM_IN_EDGE_TYPE = 1 << 0;
    this.GIGE_ARM_IN_POLARITY_MASK = 1 << 1;
    this.GIGE_ARM_IN_FALLING = 0 << 1;
    this.GIGE_ARM_IN_RISING = 1 << 1;
    //
    //// GIGE_REG_ARM_OUT_SELECT
    //// If the register is enabled, we need to specify what we're going to send.
    this.GIGE_ARM_OUT_DISABLE = 0x0000;
    this.GIGE_ARM_OUT_ENABLE = 0x0001;
    //
    this.GIGE_ARM_OUT_INTERNAL = 0 << 1;
    this.GIGE_ARM_OUT_IS_ARM_IN = 1 << 1;
    //
    this.GIGE_ARM_OUT_ACTIVE_HIGH = 1 << 4;
    this.GIGE_ARM_OUT_ACTIVE_LOW = 2 << 4;
    this.GIGE_ARM_OUT_INVERT_ARMIN = 3 << 4;
    this.GIGE_ARM_OUT_PASS_ARMIN = 4 << 4;
    this.GIGE_ARM_OUT_POLARITY_MASK = 0xf << 4;
    //
    this.GIGE_ARM_OUT_PERIOD_MASK = 0xff00;
    this.GIGE_ARM_OUT_PERIOD_SHIFT = 8;
    this.GIGE_ARM_OUT_NO_PERIOD = 0;
    //
    //// The arm-out channel starts at bit16 for channel_0.
    this.GIGE_ARM_OUT_CHANNEL_SHIFT = 16;
    //
    //// GIGE_REG_TRIG_OUT_SELECT
    this.GIGE_TRIG_OUT_DISABLE = 0x0000; // (0 << 0)
    this.GIGE_TRIG_OUT_ENABLE = 0x0001; // (1 << 0)
    //
    this.GIGE_TRIG_OUT_INTERNAL = 0 << 1;
    this.GIGE_TRIG_OUT_IS_TRIG_IN = 1 << 1;
    //
    this.GIGE_TRIG_OUT_ACTIVE_HIGH = 1 << 4;
    this.GIGE_TRIG_OUT_ACTIVE_LOW = 2 << 4;
    this.GIGE_TRIG_OUT_INVERT_TRIGIN = 3 << 4;
    this.GIGE_TRIG_OUT_PASS_TRIGIN = 4 << 4;
    this.GIGE_TRIG_OUT_POLARITY_MASK = 0xf << 4;
    //
    //// The trigger output channel starts at bit8 for channel_0.
    this.GIGE_TRIG_OUT_CHANNEL_SHIFT = 8;
    //
    this.GIGE_TRIG_OUT_PULSE_MASK = 0x3fff0000;
    this.GIGE_TRIG_OUT_PULSE_SHIFT = 16;
    //
    //// Return the "live" (aka. current) number of frames captured. As the
    //// name implies, this value is only valid while capturing frames.
    this.GIGE_REG_CUR_CAPTURE_COUNT = "0xc08c";
    //
    //// Return the current frame number. The value returned will depend upon the state of the active
    //// partition. If it's unarmed or completed 0 will be returned. If it's armed the frame number
    //// relative to the beginning of the partition will be returned. If it's triggered the frame
    //// number will be relative to the trigger position.
    this.GIGE_REG_CUR_FRAME_POS = "0xC090";
    //
    //// What is the status of HDMI on the camera. The high bit determines if HDMI is enabled or not. The
    //// rest of the register defines the resolution,
    //// with 0 being 1080p60, 1 being 720p, and 2 being 640x480, and 3 being 1080p30.
    //// The default value is 0 which is HDMI disabled with 1080p60 resolution.
    this.GIGE_REG_HDMI = "0xC094";
    this.GIGE_HDMI_ENABLE_MASK = 0x80000000;
    this.GIGE_HDMI_RESOLUTION_MASK = 0x00000003;
    //
    //// What state of the charging system is in the lowest byte (see below for details) the
    //// next byte has the battery charged 0-100
    this.GIGE_BATTERY_PERCENT_MASK = 0x0000007f;
    this.GIGE_BATTERY_STATE_MASK = 0x0000000f;
    this.GIGE_BATTERY_PERCENT_SHIFT = 8; // how many bits to shift the percent
    this.GIGE_BATTERY_NO_INFO = 0; // no information is available, communication error with charging system
    this.GIGE_BATTERY_NO_BATTERY = 1; // there is no battery hooked up to the camera
    this.GIGE_BATTERY_IDLE = 2; // system is neither charging or discharging
    this.GIGE_BATTERY_DISCHARGING = 3; // the camera is discharging its battery
    this.GIGE_BATTERY_CHARGING = 4; // the camera is charging its battery
    this.GIGE_REG_BATTERY_CHARGE = "0xC098";
    //
    //// Length of a burst for Burst-Record-On-Command mode.
    //// It would be nice if this were a further up with the trigger parameters.
    this.GIGE_REG_BROC_LEN = "0xC09C";
    this.GIGE_MIN_BROC_LEN = 10; // The shortest supported BROC burst.
    //
    //// Registers for queueing JPEG requests throught the (P0) channel - live
    //// Write only register to start the processing of a bitmap on P0. Any write will generate a JPEG.
    //// The JPEG will be generated the next time a live frame is processed.
    this.GIGE_REG_P0_PROCESS = "0xC0A0";
    //// Read only registers to return the address of where JPEG's are stored for P0
    this.GIGE_REG_JPEG_FRAME_ADDR = "0xC0A4";
    //
    //// Readonly register to return the image length of the last finished JPEG on P0.
    this.GIGE_REG_JPEG_FRAME_LEN = "0xC0A8";
    //
    //// Register to set or get the jpeg quality factor. Valid values are 1-100.
    this.GIGE_REG_JPEG_QUALITY = "0xC0AC";
    //
    ////===================================================
    //// JSON encoded register blocks
    ////===================================================
    //
    //// Register to read the JSON string for what media is attached to the camera.
    ////
    //// Possibly value tags are:
    //// "name"       The raw device name, e.g. "/dev/mmcblk0p1" for the SDCard.
    //// "type"       One of GIGE_MEDIA_xxx.
    //// "label"      The label, if any, for the volume.
    //// "devsize"    The number of bytes on the device (total size, not availability).
    //// "mountdir"   The absolute path where the device is mounted, e.g. "/media/sdcard".
    //// "tag"        The string shown to the user, e.g. "FastecMedia [8 GB]".
    this.GIGE_REG_MEDIA_JSON = "0xC0B0";
    this.GIGE_MEDIA_JSON_MAX_LEN = 512;
    //
    //// Register for media actions. JSON command with the following values:
    //// "action" : The media action being requested.
    //// "device" : The device to perform the action on.
    this.GIGE_MA_EJECT = 1 << 0; // ACTION: Eject the device
    this.GIGE_MA_FORMAT = 1 << 1; // ACTION: Format the device
    this.GIGE_REG_MA_JSON = "0xC0B4";
    //
    //// New versions of camera use a JSON command syntax for file actions.
    //// This overlays the above register space as we still need to support
    //// older cameras.
    ////
    //// Possible value tags are:
    //// "srcpath"
    //// "dstpath"        as required, i.e. _COPY, _SAVE_LOGS, etc.
    //// "action"         One of the GIGE_FA_ command values above.
    this.GIGE_REG_FA_JSON = "0xC0B8";
    //
    //// JSON command syntax for saving images to the camera-local storage.
    ////
    //// Possible value tags are:
    //// "tag"            GIGE_REG_IMAGE_TAG value
    //// "frame_start"    GIGE_REG_SAVE_START_NUM value
    //// "frame_end"      GIGE_REG_SAVE_END_NUM value
    //// "format"         GIGE_REG_STREAM_FORMAT value
    //// "dstpath"        Destination root path for saving images (i.e. "/media/FastecSSD")
    //// "dst_info"       GIGE_REG_IMAGE_DESTINATION value
    this.GIGE_REG_SAVE_JSON = "0xC0BC";
    //
    //// Sensor telemetry information.
    ////
    //// Possible value tags are:
    //// "temp_a10_ext"   FPGA external temperature reading.
    //// "temp_a10_int"   FPGA internal temperature reading.
    //// "temp_sensor"    Sensor temperature.
    //// "temp_nvme"      NVMe S.M.A.R.T. temperature.
    //// "temp_firefly"   Firefly temperature.
    //// "temp_em2120"    EM2120 PSoC temperature.
    //// "temp_pcie"      PCIe temperature.
    //// "sensor_pwr_ok"  Sensor power OK.
    //// "pmbus_alert"    PMBus OK.
    //// "em2120_I"       EM2120 current reading.
    //// "em2120_V"       EM2120 voltage reading.
    //// "firefly_V"      Firefly voltage reading.
    ////
    //// One of the following (from the FPGA ADC):
    //// "vext0"
    //// "vext1"
    //// "vcc"
    //// "vccp"
    //// "vccpt"
    //// "vcceram"
    //// "adcgnd"
    this.GIGE_REG_TELEMETRY_JSON = "0xC0C0";
    this.GIGE_TELEMETRY_JSON_LEN = 512;
    //
    ////===================================================
    ////===================================================
    //
    //// Extra time required to complete a frame.
    this.GIGE_REG_FRAME_OVERHEAD = "0xC0F0";
    //
    //// frame number being reviewed when in review mode
    this.GIGE_REG_CSI_RVW_FRAME_NUM = "0xC0F8";
    //
    //// Truncate ROC/BROC recording from this frame on.
    this.GIGE_REG_TRUNCATE = "0xC0FC";
    //
    ////===================================================
    ////  Specific Partition Information
    ////===================================================
    //
    //// State of the active partition (see below i.e. GIGE_PART_STATE_EMPTY).
    this.GIGE_REG_PART_STATE = "0xC100";
    //
    //// Return the per-frame metadata. This will read the
    //// frame specified by GIGE_REG_ACTIVE_FRAME_NUM.
    this.GIGE_REG_FRAME_METADATA = "0xC104";
    this.GIGE_FRAME_METADATA_LEN = 32;
    //
    //// Return the number of frames actually recorded in the active partition.
    //// This will only work on partitions which have already been recorded
    //// otherwise will return 0.
    this.GIGE_REG_PART_NUM_FRAMES = "0xC140";
    //
    //// Return the trigger frame number for the active partition.
    this.GIGE_REG_PART_TRIG_FRAME = "0xC180";
    //
    //// Registers for a raw histogram.  GIGE_REG_HISTOGRAM_RAW_SIZE will read the raw histogram from
    //// the FPGA and return the size which can change based upon sensor.
    //// For the Lupa1300 it will be 0x1000 bytes.
    //// The second register GIGE_REG_HISTOGRAM_RAW will read the return the next 512 bytes
    //// of the histogram. So for the Lupa1300 it will take 8 reads to get the whole thing. If the
    //// GIGE_REG_HISTOGRAM_RAW_SIZE it called again it will reset the pointer for
    //// the histogram and start reading from the begining again.
    this.GIGE_HISTOGRAM_READ_SIZE = 512;
    this.GIGE_REG_HISTOGRAM_RAW_SIZE = "0xC200";
    this.GIGE_REG_HISTOGRAM_RAW = "0xC204";
    //
    //// Registers for processed RGB histograms
    //
    //// lower two bytes are the size of the histogram
    //// upper two byts are the offset of the histogram
    this.GIGE_HISTO_RGB_ROI_SIZE_SHIFT = 0;
    this.GIGE_HISTO_RGB_ROI_OFF_SHIFT = 16;
    this.GIGE_REG_HISTO_RGB_ROI_X = "0xC208";
    this.GIGE_REG_HISTO_RGB_ROI_Y = "0xC20C";
    //
    //// Read only register to return the peak bin numbers with the highest count values
    //// low byte is the blue value, next byte is the green, next byte is the red value
    this.GIGE_HISTO_RGB_PEAK_BLU_MASK = 0x000000ff;
    this.GIGE_HISTO_RGB_PEAK_GRN_MASK = 0x0000ff00;
    this.GIGE_HISTO_RGB_PEAK_RED_MASK = 0x00ff0000;
    this.GIGE_HISTO_RGB_PEAK_BLU_SHIFT = 0;
    this.GIGE_HISTO_RGB_PEAK_GRN_SHIFT = 8;
    this.GIGE_HISTO_RGB_PEAK_RED_SHIFT = 16;
    this.GIGE_REG_HISTO_RGB_PEAK = "0xC210";
    //
    //// The next three RO registers return the sum of all the specific color value in the histogram roi
    this.GIGE_REG_HISTO_RGB_SUM_X_RED = "0xC214";
    this.GIGE_REG_HISTO_RGB_SUM_X_GRN = "0xC218";
    this.GIGE_REG_HISTO_RGB_SUM_X_BLU = "0xC21C";
    //
    //// The next six RO registers return the upper 5 bits of the sum of all the specific color value
    //// squared within the histogram roi in the high register and the other 32 bits in the low reg
    this.GIGE_HISTO_RGB_SUM_X_HIGH_MASK = 0x0000001f;
    this.GIGE_REG_HISTO_RGB_SUM_X_SQRD_RED_L = "0xC220";
    this.GIGE_REG_HISTO_RGB_SUM_X_SQRD_RED_H = "0xC224";
    this.GIGE_REG_HISTO_RGB_SUM_X_SQRD_GRN_L = "0xC228";
    this.GIGE_REG_HISTO_RGB_SUM_X_SQRD_GRN_H = "0xC22C";
    this.GIGE_REG_HISTO_RGB_SUM_X_SQRD_BLU_L = "0xC230";
    this.GIGE_REG_HISTO_RGB_SUM_X_SQRD_BLU_H = "0xC234";
    //
    //// The next registers tell the IPM to generate a histogram on the next image through the IPM
    //// a 1-P0, 2=P1, 3=P2
    this.GIGE_GENERATE_RGB_HISTO_CHAN_P0 = 1;
    this.GIGE_GENERATE_RGB_HISTO_CHAN_P1 = 2;
    this.GIGE_GENERATE_RGB_HISTO_CHAN_P2 = 3;
    this.GIGE_REG_GENERATE_RGB_HISTO = "0xC238";
    //
    //// Registers to retrieve the RGB histogram.  GIGE_REG_HISTO_RBG_SIZE will read the histogram from
    //// the FPGA and return the size which can change based upon sensor.
    //// For the Lupa1300 it will be 0xC00 bytes the first 0x400 will be the 256 (4 byte) entries for red,
    //// the next 0x400 will be green, the last 0x400 will be blue.
    //// The second register GIGE_REG_HISTO_RGB will read the return the next 512 bytes
    //// of the histogram. So for the Lupa1300 it will take 6 reads to get the whole thing. If
    //// GIGE_REG_HISTO_RGB_SIZE it called again it will reset the pointer for
    //// the histogram and start reading from the begining again. To read the value a readmem must be used.
    this.GIGE_REG_HISTO_RGB_SIZE = "0xC23C";
    this.GIGE_REG_HISTO_RGB = "0xC240";
    //
    //// Registers to read/write the current settings information. Reading GIGE_REG_CONFIG_SIZE will
    //// let the user know how many bytes are in the configuration data. Writing GIGE_REG_CONFIG_SIZE
    //// has no effect. The actual data is read/written via the GIGE_REG_CONFIGURATION register,
    //// which uses readmem/writemem functions. The first byte of data written to the GIGE_REG_CONFIGURATION
    //// must be a control packet with one of the flags indiciating if this is a start, data, or last
    //// packet.
    this.GIGE_CONFIG_MAX_XFER_COUNT = 512;
    this.GIGE_CONFIG_START_PACKET = 0x01;
    this.GIGE_CONFIG_DATA_PACKET = 0x02;
    this.GIGE_CONFIG_LAST_PACKET = 0x04;
    this.GIGE_REG_CONFIG_SIZE = "0xC244";
    this.GIGE_REG_CONFIGURATION = "0xC248";
    //
    //// Hold off writing capture parameters until hold is released or lock times out, or any
    //// non-capture parameter is written. Any subset of the available hold-eligible parameters
    //// can be written. Capture parameters eligible for hold are:
    //// GIGE_REG_WIDTH, GIGE_REG_HEIGHT, GIGE_REG_OFFSET_X, GIGE_REG_OFFSET_Y
    //// GIGE_REG_FRAME_RATE, GIGE_REG_SHUTTER_SPEED, GIGE_REG_SENSOR_OPTS, GIGE_REG_BIT_MODE
    //// Write 1 to start holding, 0 to commit the changes.
    this.GIGE_REG_HOLD = "0xC24C";
    //
    //// Registers to set the matrix coefficients
    //// These registers contain the 3x3 correction matrix. The format is 8.8 (2's complement format
    //// with low byte fraction the next byte whole amount
    this.GIGE_REG_MATRIX_COEFF1_RED = "0xC250";
    this.GIGE_REG_MATRIX_COEFF2_RED = "0xC254";
    this.GIGE_REG_MATRIX_COEFF3_RED = "0xC258";
    this.GIGE_REG_MATRIX_COEFF1_GRN = "0xC25C";
    this.GIGE_REG_MATRIX_COEFF2_GRN = "0xC260";
    this.GIGE_REG_MATRIX_COEFF3_GRN = "0xC264";
    this.GIGE_REG_MATRIX_COEFF1_BLU = "0xC268";
    this.GIGE_REG_MATRIX_COEFF2_BLU = "0xC26C";
    this.GIGE_REG_MATRIX_COEFF3_BLU = "0xC270";
    //
    //// White balance registers. These are 8.8 values. The low byte is the fraction amount
    //// the next byte is the whole amount.
    this.GIGE_REG_WHITE_BALANCE_RED = "0xC274";
    this.GIGE_REG_WHITE_BALANCE_GRN = "0xC278";
    this.GIGE_REG_WHITE_BALANCE_BLU = "0xC27C";
    //
    //// Generate a custom white balance, the camera state must be unarmed live view for
    //// this command to work. Have the user point the camera at a white background and
    //// then just write any value will cause the CS to geneate the custom white balance
    //// values. When this register returns with a successful value the above three
    //// registers will be filled in the generated values.
    this.GIGE_REG_GENERATE_CUSTOM_WB = "0xC280";
    //
    //// The following registers control the double and triple slope shutter speeds. The
    //// values are in uSec and GIGE_REG_DS_SHUTTER_SPEED must be less than
    //// GIGE_REG_SHUTTER_SPEED, GIGE_REG_TS_SHUTTER_SPEED must be less then
    //// GIGE_REG_DS_SHUTTER_SPEED a value of 0 turns off double and tripple slopes.
    this.GIGE_REG_DS_SHUTTER_SPEED = "0xC284";
    this.GIGE_REG_TS_SHUTTER_SPEED = "0xC288";
    //
    //// Write only register to tell the CS to update the metadata with the latest settings
    //// this applies to display settings. Record settings were saved whe the partition had
    //// finished recording.
    this.GIGE_REG_UPDATE_METADATA = "0xC28C";
    //
    //// This register allows the client to specify where the CS should write data.
    //// The type is specified using the GIGE_STREAM_FORMAT_XXX values.
    this.GIGE_REG_IMAGE_DESTINATION = "0xC290";
    //
    //// -------------------------------------------------
    //// b0:3 - GIGE_STREAM_FORMAT_XXX value.
    //// b4:7 - Unused
    //// b8:11 - GIGE_IMAGE_DEST_XXX
    //// GIGE_IMAGE_DEST values are consistent with old definitions, just not defined the same way.
    this.GIGE_DEST_SHIFT = 8;
    this.GIGE_DEST_FIELD_MASK = 0x0f;
    //
    this.GIGE_IMAGE_DEST_SDCARD = 0x01 << this.GIGE_DEST_SHIFT;
    this.GIGE_IMAGE_DEST_SSD = 0x02 << this.GIGE_DEST_SHIFT;
    this.GIGE_IMAGE_DEST_USB = 0x04 << this.GIGE_DEST_SHIFT;
    this.GIGE_IMAGE_DEST_LOCAL_STREAM = 0x08 << this.GIGE_DEST_SHIFT;
    this.GIGE_IMAGE_DEST_OFF_CAMERA = 0x0f << this.GIGE_DEST_SHIFT;
    this.GIGE_IMAGE_DEST_MASK = this.GIGE_DEST_FIELD_MASK << this.GIGE_DEST_SHIFT;
    //
    //// b12:21 - GIGE_PLAYBACK_RATE
    this.GIGE_PLAYBACK_RATE_SHIFT = 12;
    this.GIGE_PLAYBACK_RATE_MASK = 0x3ff << this.GIGE_PLAYBACK_RATE_SHIFT;
    //
    //// b21:24 - Unused
    this.GIGE_IMAGE_SAVE_XML = 1 << 25;
    this.GIGE_IMAGE_SAVE_DELAY = 1 << 26;
    this.GIGE_IMAGE_PREP_SNAP = 1 << 27;
    this.GIGE_IMAGE_SNAPSHOT = 1 << 28;
    this.GIGE_IMAGE_USE_TAG = 1 << 29;
    this.GIGE_IMAGE_USE_CAMERA_NAME = 1 << 30;
    //// b31 - GIGE_STREAM_FORMAT_RAW
    //// -------------------------------------------------
    //
    //// What format do we want to use when streaming the data?
    this.GIGE_REG_STREAM_FORMAT = "0xC294";
    this.GIGE_STREAM_FORMAT_FIRST = 1; // First legal value for stream format.
    this.GIGE_STREAM_FORMAT_JPEG = 1; // stream the images in JPEG format.
    this.GIGE_STREAM_FORMAT_BMP = 2; // stream the images in bitmap format.
    this.GIGE_STREAM_FORMAT_TIF = 3; // stream the images in TIFF format.
    this.GIGE_STREAM_FORMAT_DNG = 4; // stream the images in DNG format.
    this.GIGE_STREAM_FORMAT_AVI = 5; // AVI format (used for file saves more than streaming).
    this.GIGE_STREAM_FORMAT_CAPTURE = 6; // Partition captures.
    this.GIGE_STREAM_FORMAT_META_ONLY = 7; // Don't save images, just save the metadata.
    this.GIGE_STREAM_FORMAT_MAX = 7; // Number of known formats, last legal value.
    this.GIGE_STREAM_FORMAT_MASK = 0x0000000f;
    this.GIGE_STREAM_FORMAT_RAW = 1 << 31; // Fastec raw format modifier, for TIFF specifically.
    //
    //// Provide a register interface to show our save "state" - are we busy saving an
    //// image, or are we idle? If the error bit is set, then the lower bits indicate the
    //// error code.
    this.GIGE_REG_SAVE_STATE = "0xC298";
    this.GIGE_SAVE_STATE_ERR_MASK = 0xffff;
    this.GIGE_SAVE_STATE_FLAGS = 0xf << 28;
    this.GIGE_SAVE_STATE_ERR = 0x1 << 30;
    this.GIGE_SAVE_STATE_BUSY = 0;
    this.GIGE_SAVE_STATE_IDLE = 0x1 << 31;
    //
    //// If the user wants to specify a TAG for the file name, then they need
    //// to write that data into this register.
    this.GIGE_REG_IMAGE_TAG = "0xC29C";
    this.GIGE_IMAGE_TAG_MAX_LEN = 32;
    //
    //// The following registers are used to retrieve a partitions metadata.
    //// First one writes to GIGE_REG_ACTIVE_METADATA to initialize the parameters.
    //// Next one issues repeated readmems of GIGE_MAX_METADATA_BLOCK length (or less) to
    //// GIGE_REG_ACTIVE_METADATA to read the data (total length is sizeof( pm_metadata )).
    this.GIGE_MAX_METADATA_BLOCK = 512;
    this.GIGE_REG_ACTIVE_METADATA = "0xC2A0";
    //
    //// Grab the XML formatted metadata which contains the per-frame metadata.
    //// Write to the register (data doesn't matter) to create the metadata and
    //// prepare it for download. Issue repeated readmems to download it.
    //// Do a regular register read to get the length of the data.
    this.GIGE_REG_XML_METADATA = "0xC2A4";
    //
    //// A register to read the temperature sensors within the camera.
    //// The MS word (16-bits) of the register contains the component
    //// side value, the LS word contains the imager (sensor or front)
    //// side value. The values are in 10ths degree centigrade.
    this.GIGE_TEMPERATURE_MASK = 0xffff;
    this.GIGE_CSIDE_SHIFT = 16;
    this.GIGE_REG_TEMPERATURE = "0xC2A8";
    //
    //// A register to set the marker search filter pattern which is saved in non-volatile storage
    //// for reload on the next boot. Can be read and written.
    //// The GIGE_MARKER_FILTER_ENABLE bit is to save that state along with the filter for the GUI to
    //// recover on reboot. To retrieve the list, after setting ENABLE, it is still necessary to write
    //// to GIGE_REG_MARKER_LIST first, then readmem after its size is no longer -1. If the ENABLE bit
    //// was not set, the size will be 0.
    this.GIGE_REG_MARKER_FILTER = "0xC2AC";
    //// b18:31 are available as flag bits
    this.GIGE_MARKER_FILTER_ENABLE = 1 << 31;
    this.GIGE_MARKER_OP_MASK = 1 << 30;
    this.GIGE_MARKER_OP_AND = 1 << 30;
    this.GIGE_MARKER_OP_OR = 0 << 30;
    //// b0:23 - 3-bit match filter per marker, eight markers
    this.GIGE_MARKER_FILTER_ALL = 0x3ffff; // Mask for filters for all inputs.
    this.GIGE_MARKER_NUM_INPUTS = 8; // Number of marker bits to filter on.
    this.GIGE_MARKER_BITS_PER_FILTER = 3; // Number of bits to specify a filter.
    this.GIGE_MARKER_FILTER_MASK = 7; // 3-bit mask for match filter
    this.GIGE_MARKER_FILTER_X = 0; // 000 - Don't care
    //// Unused				1	// 001 - unused
    this.GIGE_MARKER_FILTER_LOW = 2; // 010 - Low level
    this.GIGE_MARKER_FILTER_HIGH = 3; // 011 - High level
    this.GIGE_MARKER_FILTER_CHANGE = 4; // 100 - Any change in level
    this.GIGE_MARKER_FILTER_GLITCH = 5; // 101 - Edge but no level change
    this.GIGE_MARKER_FILTER_FALL = 6; // 110 - Low level after an edge
    this.GIGE_MARKER_FILTER_RISE = 7; // 111 - High level after an edge
    //
    //// A register to access a list of frames matching the marker search filter pattern.
    //// The list is cleared when GIGE_REG_MARKER_FILTER is changed and then must be
    //// reconstructed. Write to this register to start construction of the list.
    //// After the write, a register read returns (uint32_t)(-1) until the list
    //// construction operation is complete, then a register read returns the size
    //// of the list. Use successive readmem operations to read the list, which is
    //// a list of frame numbers that match the filter.
    //// (For future implementation to support the web interface: The list is also
    //// constructed automatically if a NEXT or PREV operation is done.
    this.GIGE_REG_MARKER_LIST = "0xC2B0";
    //// This flag indicates a run of frames matching the filter. The run extends from the frame number
    //// in the entry before this flag to the frame number in the entry following this flag.
    this.MARKER_LIST_RUN_FLAG = 0xffffffff;
    //// Maximum number of event markers we include in the list, so a buffer for the list needs
    //// at most 4KB = (sizeof(uint32_t)*MARKER_LIST_MAX_COUNT) bytes.
    this.MARKER_LIST_MAX_COUNT = 1024;
    //
    //// Define the save parameter registers.
    this.GIGE_REG_SAVE_START_NUM = "0xC2B4";
    this.GIGE_REG_SAVE_END_NUM = "0xC2B8";
    //
    //// Define a register for readmem/writemem of the capture comment field.
    this.GIGE_REG_COMMENT = "0xC2BC";
    //// The maximum comment is 30 characters plus a terminating null byte.
    //// Anything longer will be truncated.
    this.GIGE_COMMENT_MAX_LEN = 31;
    //
    //// Define a register for transfers of user LUT file.
    ////
    //// To transfer a file, first do a register write of the LUT# to GIGE_REG_LUT_DATA, which sets the
    //// LUT number for the file transfer and resets the file offset for the readmem/writemem.
    //// Each packet starts with 32-bit offset into the LUT file, high-byte first (network byte order).
    //// When writemem is complete (offset and byte count indicate end of file was written),
    //// the old LUT file is replaced. Then write GIGE_REG_LUT to load from the new file.
    ////
    //// File data spline control points are in camera native byte order (little endian).
    //// The file data is
    ////
    ////     struct {
    ////         char    description[LUT_DESCRIPTION_LEN + 1];
    ////         char    unused_force_alignment;
    ////         // Spline control points, aka knots, are in order by X coordinate, low to high.
    ////         // First has x=0. Last has x=1023. Any entries after x=1023 are ignored.
    ////         struct {
    ////             uint16_t x;        // 0-1023
    ////             uint16_t y;        // 0-255
    ////         } spline_controls[LUT_MAX_KNOT_COUNT];
    ////         uint8_t table[LUT_MAX_TABLE_COUNT];
    ////     };
    this.GIGE_REG_LUT_DATA = "0xC2C0";
    //
    this.LUT_DESCRIPTION_LEN = 30; // Max chars in the description, followed by null char.
    this.LUT_MAX_KNOT_COUNT = 16; // Maximum number of knots for a spline LUT.
    this.LUT_MAX_TABLE_COUNT = 1024; // Number of entries in the LUT data table.
    //
    //// Define the load parameter registers. To use these, one will write
    //// the file name of the file to load (located on the root of the SSD).
    //// To initiate the load operation write GIGE_LOAD_START to the
    //// GIGE_REG_LOAD register. Read the register to get status. The
    //// FILE_NAME_MAX value includes the maximum length for the camera name
    //// (16), the maximum length for the tag (32), seperators, file suffix
    //// (.cap), and file numbering.
    this.GIGE_REG_LOAD_FILE_NAME = "0xC2C4";
    this.GIGE_LOAD_FILE_NAME_MAX = 0x40;
    this.GIGE_REG_LOAD = "0xC2E4";
    this.GIGE_LOAD_START = 1 << 0;
    this.GIGE_LOAD_STOP = 0;
    this.GIGE_LOAD_ERROR = 1 << 30;
    this.GIGE_LOAD_BUSY = 1 << 31;
    this.GIGE_LOAD_STATUS_MASK = 0x3fffffff;
    //
    //// The following registers have to do with the Active Partition GIGE_REG_ACTIVE_PART,
    //// the definition of which can vary by camera state. In unarmed mode it is either
    //// the first empty partition or the last recorded one if no partitions are empty.
    //// In armed mode it is the partition being recorded to. In review mode it is the
    //// partition being reviewed.
    //// Unused 0xC300, was GIGE_REG_ACTIVE_CT_ADDR
    this.GIGE_REG_ACTIVE_FRAME_NUM = "0xC304";
    //// Unused 0xC308, was GIGE_REG_ACTIVE_FRAME_ADDR
    //
    //// The following registers are used for configuring WIFI network settings
    this.GIGE_REG_WIFI_IP_CUR_CFG = "0xC310";
    this.GIGE_REG_WIFI_IP_ADDR = "0xC314";
    this.GIGE_REG_WIFI_SUBNET_MASK = "0xC318";
    this.GIGE_REG_WIFI_DEF_GATEWAY = "0xC31C";
    this.GIGE_REG_WIFI_SSID = "0xC320";
    this.GIGE_WIFI_SSID_MAX = 0x0020;
    this.GIGE_REG_WIFI_PASSPHRASE = "0xC340";
    this.GIGE_WIFI_PASSPHRASE_MAX = 0x0040;
    this.GIGE_REG_WIFI_STATUS = "0xC380";
    this.GIGE_REG_WIFI_START_SCAN = "0xC384";
    this.GIGE_REG_WIFI_SCAN_RESULTS = "0xC388";
    this.GIGE_WIFI_SCAN_RESULTS_READ_SIZE = 512;
    this.GIGE_REG_WIFI_AP_CFG = "0xC588";
    //
    this.GIGE_REG_FASTEC_CCP = "0xC58C";
    //
    //// Use the FILE_ACTION register to initiate an action on the
    //// file/folder specified in the FILEPATH register. When the
    //// action requires a destination, use the values defined in
    //// GIGE_REG_IMAGE_DESTINATION. For example, if you wanted
    //// to copy from "/media/ssd/dcim/100fastc/ts3_000000" to the
    //// SDCARD, you would put the source path string into the
    //// GIGE_REG_FILEPATH register, and you would set the GIGE_REG_FILEACTION
    //// register to (GIGE_FA_COPY | GIGE_IMAGE_DEST_SDCARD).
    //// For GIGE_FA_LUT_LISTING, no source string is needed so GIGE_REG_FILEPATH need not be set.
    ////
    //// Poll GIGE_REG_FILE_ACTION_STATUS to determine if the operation
    //// is complete. If the GIGE_FA_STATUS_ERROR bit is set, then the
    //// low order bits indicate the error code (typically errno). If
    //// the GIGE_FA_STATUS_BUSY bit is set, then the low order bits
    //// indicate any useful additional information (perhaps number of
    //// file copied for example).
    ////
    //// For GIGE_FA_LISTING, the XML listing of the folder specified by
    //// GIGE_REG_FILEPATH can be read by memory reads of GIGE_REG_FILEPATH.
    //// The XML buffer length can be read from GIGE_REG_FILE_ACTION_STATUS.
    this.GIGE_REG_FILEPATH = "0xC590";
    this.GIGE_FILEPATH_LEN = 512;
    this.GIGE_REG_FILE_ACTION = "0xC790";
    this.GIGE_FA_CANCEL = 0;
    this.GIGE_FA_DELETE = 1;
    this.GIGE_FA_COPY = 2;
    this.GIGE_FA_LISTING = 3;
    this.GIGE_FA_SAVE_LOGS = 4;
    this.GIGE_FA_LUT_LISTING = 5;
    this.GIGE_FA_OP_MASK = 0xff;
    this.GIGE_REG_FILE_ACTION_STATUS = "0xC794";
    this.GIGE_FA_STATUS_ERROR = 1 << 30;
    this.GIGE_FA_STATUS_IDLE = 0;
    this.GIGE_FA_STATUS_BUSY = 1 << 31;
    this.GIGE_FA_STATUS_MASK = 0x3fffffff;
    //
    ////---------------------------------------------------
    //// FPGA time interface.
    ////---------------------------------------------------
    this.GIGE_REG_IRIG_CONTROL = "0xC7A0";
    this.GIGE_IRIG_USE_YEAR = 1 << 30;
    this.GIGE_IRIG_ENABLE = 1 << 31;
    this.GIGE_IRIG_DISABLE = 0;
    this.GIGE_REG_IRIG_STATUS = "0xC7A4";
    this.GIGE_IRIG_ALLOWED = 1 << 0;
    this.GIGE_IRIG_LOCKED = 1 << 1;
    this.GIGE_REG_TIME_SBS = "0xC7A8";
    this.GIGE_REG_TIME_SBUS = "0xC7AC";
    //
    ////===================================================
    //// LTR register definitions
    //// Eventually this will probably become just GIGE_REG_MODE
    //// when we add ROC and BROC to non-LTR operations.
    ////===================================================
    this.GIGE_REG_LTR_MODE = "0xC7B0";
    this.GIGE_LTR_MODE_ENABLE = 1 << 31;
    this.GIGE_LTR_MODE_DUAL = 1 << 30;
    this.GIGE_LTR_MODE_ROC = 1 << 29;
    this.GIGE_LTR_MODE_BROC = 1 << 28;
    //
    this.GIGE_REG_LTR_SECTOR_COUNT = "0xC7B4";
    //
    //// Unused register space here 0xC7B8, 0xC7BC, 0xC7C0
    //
    //// This register returns the bandwidth used by the FPGA
    //// when transferring to/from the SSD.
    this.GIGE_REG_SSD_BANDWIDTH = "0xC7C4";
    //
    //// Allow the UIs to query about drive capabilities, such as
    //// Block Erase (Sanitize) support.
    this.GIGE_REG_SSD_CAPABILITIES = "0xC7C8";
    this.GIGE_SSD_CAP_SANITIZE = 1 << 0; // Drive supports sanitize operation if set.
    //
    ////===================================================
    ////
    ////  ...next reg should be at  0xC7CC
    ////
    ////===================================================
    //
    //
    ////===================================================
    ////  String Register Size
    ////===================================================
    //
    ////! Maximum size of a string register
    this.GIGE_REG_STR_MAX_SIZE = "48";
    //
    ////===================================================
    ////  Bit Patterns
    ////===================================================
    //
    ////! Bit patterns for the GIGE_REG_DEV_MODE(0x4) register
    ////! provided reversed in BE order for staticically initializing the registers.
    this.GIGE_MODE_BIG_ENDIAN_BE = 1; // 1
    this.GIGE_MODE_PERIPHERAL_BE = 3; // 3 << 1
    this.GIGE_MODE_UTF8_BE = 1; // 1 << 31
    ////#define GIGE_MODE_BIG_ENDIAN		1		// 1
    ////#define GIGE_MODE_PERIPHERAL		3 << 1		// 3 << 1
    ////#define GIGE_MODE_UTF8		1 << 31		// 1 << 31
    //
    ////! Bit patterns for the GIGE_REG_IP_CFG and GIGE_REG_IP_CUR_CFG Register
    ////! provided reversed in BE order for staticically initializing the registers.
    this.GIGE_IFCONFIG_LLA_BE = 1;
    this.GIGE_IFCONFIG_DHCP_BE = 1;
    this.GIGE_IFCONFIG_PERSISTENT_BE = 1;
    ////#define GIGE_IFCONFIG_LLA		1 << 29
    ////#define GIGE_IFCONFIG_DHCP		1 << 30
    ////#define GIGE_IFCONFIG_STATIC	 	1 << 31
    //
    ////! Bit patterns for the FCP Capabilities Register
    this.GIGE_CAP_UN_BE = 1;
    this.GIGE_CAP_SN_BE = 1;
    this.GIGE_CAP_HD_BE = 1;
    this.GIGE_CAP_LS_BE = 1;
    this.GIGE_CAP_CAP_BE = 1;
    this.GIGE_CAP_MT_BE = 1;
    this.GIGE_CAP_TD_BE = 1;
    this.GIGE_CAP_DD_BE = 1;
    this.GIGE_CAP_WD_BE = 1;
    this.GIGE_CAP_ES_BE = 1;
    this.GIGE_CAP_PAS_BE = 1;
    this.GIGE_CAP_A_BE = 1;
    this.GIGE_CAP_P_BE = 1;
    this.GIGE_CAP_ED_BE = 1;
    this.GIGE_CAP_E_BE = 1;
    this.GIGE_CAP_PR_BE = 1;
    this.GIGE_CAP_W_BE = 1;
    this.GIGE_CAP_C_BE = 1;
    //
    ////! Bit patterns for the FCP Control Access register.
    this.GIGE_CCP_CA_BE = 0x2;
    //
    ////! Bit patterns for the Fastec-specific Control Access register.
    this.GIGE_FASTEC_CCP_CA_BE = 0x2;
    this.GIGE_FASTEC_CCP_OVERRIDE_BE = 0x4;
    //
    ////!Bit patterns for the stream registers. These are swapped because the document
    ////is from the perspective of BE
    ////#define GIGE_SCPX_FTP			1 << 31  // fire test packet
    ////#define GIGE_SCPX_DNF			1 << 30  // do not fragment
    //
    ////! Bit patterns for the GIGE_REG_SCPS, the register has been swapped because we
    ////! have a numeric value in it. So these are offset within the first byte
    ////#define GIGE_SCPSX_FTP_BE		1 << 7	//!< Fire test packet
    ////#define GIGE_SCPSX_DNF_BE		1 << 6	//!< Do not fragment
    ////#define GIGE_SCPSX_PXL_BE_BE		1 << 5	//!< Pixel endianness big endian
    this.GIGE_SCPSX_FTP_BE = 1; //!< Fire test packet
    this.GIGE_SCPSX_DNF_BE = 1; //!< Do not fragment
    this.GIGE_SCPSX_PXL_BE_BE = 1; //!< Pixel endianness big endian
    //
    this.GIGE_DEFAULT_HEARTBEAT = 3000; //!< heartbeat timeout interval in ms
    this.GIGE_DEFAULT_NUM_STREAMS = 1; //!< how many streams are we supporting
    this.GIGE_VER_MAJOR = 1; //!< major version
    this.GIGE_VER_MINOR = 2; //!< minor version
    //
    //// State values for register GIGE_REG_CAMERA_STATE, matches eCameraState.
    this.GIGE_CAMERA_STATE_IDLE = 0; //!< idle onTS3 (from memory HiSpec)
    this.GIGE_CAMERA_STATE_LIVE_VIDEO = 1 << 0; //!< 1 unarmed live video on TS3 (Live video HiSpec)
    this.GIGE_CAMERA_STATE_ARMED = 1 << 1; //!< 2 Armed on TS3 (not defined on HiSpec)
    this.GIGE_CAMERA_STATE_TRIGGERED = 1 << 2; //!< 4 Triggered on TS3 (not defined on HiSpec)
    this.GIGE_CAMERA_STATE_REVIEW = 1 << 3; //!< 8 Review mode (not defined on HiSpec)
    this.GIGE_CAMERA_STATE_SNAPSHOT = 1 << 4; //!< 16 Take snapshot and leave camera in this mode.
    this.GIGE_CAMERA_STATE_AUTOSAVE = 1 << 5; //!< 32 Camera is in autosave "saving" state.
    this.GIGE_CAMERA_STATE_DEARMING = 1 << 6; //!< 64 Camera is stopping capture prematurely.
    //
    //// Valid bit modes for setting within the sensor. Update macros if definitions are changed.
    this.GIGE_BITMODE_LOWER_8_BITS = 0x00; //!< Lower 8 bits of sensor data
    this.GIGE_BITMODE_MIDDLE_8_BITS = 0x01; //!< Middle 8 bits of sensor data
    this.GIGE_BITMODE_UPPER_8_BITS = 0x02; //!< Upper 8 bits of sensor data
    this.GIGE_BITMODE_10_BITS = 0x03; //!< All 10 bits of sensor data for 10-bit sensor
    this.GIGE_BITMODE_7_0 = 0x10; //!< Bits 7:0
    this.GIGE_BITMODE_8_1 = 0x11; //!< Bits 8:1
    this.GIGE_BITMODE_9_2 = 0x12; //!< Bits 9:2
    this.GIGE_BITMODE_10_3 = 0x13; //!< Bits 10:3
    this.GIGE_BITMODE_11_4 = 0x14; //!< Bits 11:4
    this.GIGE_BITMODE_9_0 = 0x20; //!< Bits 9:0
    this.GIGE_BITMODE_10_1 = 0x21; //!< Bits 10:1
    this.GIGE_BITMODE_11_2 = 0x23; //!< Bits 11:2
    this.GIGE_BITMODE_11_0 = 0x30; //!< Bits 11:0
    //
    //// Macros for classifying the bit mode
    //#define IS_8_BIT_MODE( x ) (( (x) <= GIGE_BITMODE_UPPER_8_BITS ) || \
    //			    (( GIGE_BITMODE_7_0 <= (x) ) && ( (x) <= GIGE_BITMODE_11_4 )))
    //#define IS_10_BIT_MODE( x ) (( (x) == GIGE_BITMODE_10_BITS ) || \
    //			    (( GIGE_BITMODE_9_0 <= (x) ) && ( (x) <= GIGE_BITMODE_11_2 )))
    //#define IS_12_BIT_MODE( x ) ( (x) == GIGE_BITMODE_11_0 )
    //
    //// Partition states
    this.GIGE_PART_STATE_EMPTY = 0; //!< partition is empty
    this.GIGE_PART_STATE_ARMED = 1; //!< partition is active and armed
    this.GIGE_PART_STATE_TRIGGERED = 2; //!< partition is active and triggered
    this.GIGE_PART_STATE_COMPLETE = 3; //!< partition recording is complete
    this.GIGE_PART_STATE_LOCKED = 4; //!< partition has been locked
    //
    //// HDMI settings.
    this.GIGE_HDMI_ENABLE = 1 << 31; //!< Enable the HDMI output.
    this.GIGE_HDMI_1080P = 0; //!< Default 1080p option is 1080p60.
    this.GIGE_HDMI_1080P60 = 0;
    this.GIGE_HDMI_720P = 1;
    this.GIGE_HDMI_640 = 2;
    this.GIGE_HDMI_1080P30 = 3;
    //
    //// JPEG Quality settings
    this.GIGE_JPEG_QUAL_MIN = 1;
    this.GIGE_JPEG_QUAL_MAX = 100;
    //
    //// EVENT DATA Constants
    this.GIGE_NO_STREAM_CHANNEL = 0xffff;
    //
    //// AsShotNeutral constants
    this.AS_SHOT_SHIFT = 28;
    //
    //// WIFI status
    this.GIGE_WIFI_STATUS_DONGLE = 0x01;
    this.GIGE_WIFI_STATUS_CONNECTED = 0x02;
    this.GIGE_WIFI_STATUS_SIGNAL_MASK = 0xff00;
    this.GIGE_WIFI_STATUS_SIGNAL_SHIFT = 8;
    //
    //// WIFI config
    this.GIGE_WIFI_AP_CFG_SEC_MASK = 0x03;
    this.GIGE_WIFI_AP_CFG_SEC_UNKNOWN = 0x00;
    this.GIGE_WIFI_AP_CFG_SEC_OPEN = 0x01;
    this.GIGE_WIFI_AP_CFG_SEC_WEP = 0x02;
    this.GIGE_WIFI_AP_CFG_SEC_WPA = 0x03;
    //
    //
    this.GIGE_WIFI_AP_CFG_ADHOC = 0x04; // flag
    //
    //// This is the named socket for talking with the GUI.
    this.TS3_GUI_NAMED_SOCKET = "/tmp/ts3gui.queue";
    //
    //// State values
    ////===================================================
    ////  Structures
    ////===================================================
    //// The following is a structure which defines how meta data is stored inside a partition.
    //#pragma pack(1)
    //typedef struct pm_metadata_type
    //{
    //    /* 0x000 */ char	man_name[ GIGE_DSC_ACK_VENDOR_B_LEN ];
    //    /* 0x020 */ char	model_name[ GIGE_DSC_ACK_MODEL_B_LEN ];
    //    /* 0x040 */ char	serial_num[ GIGE_DSC_ACK_SERIAL_B_LEN ];
    //    /* 0x050 */ char	app_ver[ GIGE_DSC_ACK_VERSION_B_LEN ];
    //    /* 0x070 */ char	camera_name[ GIGE_DSC_ACK_USER_NAME_B_LEN ];
    //    /* 0x080 */ uint8_t	mac_addr[ GIGE_DSC_ACK_MAC_B_LEN ];
    //
    //    /* 0x086 */ uint8_t	bit_sel;	// bit selection, gige_msg.h i.e. GIGE_BITMODE_LOWER_8_BITS
    //    /* 0x087 */ uint8_t	old_sensor_gain;
    //
    //    /* 0x088 */ uint32_t	fpga_rev;	// high byte ver major, next ver minor, low two patch level
    //    /* 0x08C */ uint16_t	roi_x;
    //    /* 0x08E */ uint16_t	roi_y;
    //    /* 0x090 */ uint16_t	roi_width;
    //    /* 0x092 */ uint16_t	roi_height;
    //    /* 0x094 */ uint32_t	fps;		// frames per second
    //    /* 0x098 */ uint32_t	shutter_speed;  // exposure time, microsecond resolution
    //    /* 0x09C */ uint32_t	sensor_type;	// Type of sensor 'L13M' = Lupa1300 mono, 'L13C'=Lupa1300 color
    //    /* 0x0A0 */ char  	gps_loc[64];	// GPS location if available, otherwise a null string
    //    /* 0x0E0 */ uint32_t 	frame_count;	// total number of frames captured
    //    /* 0x0E4 */ uint32_t 	frame_size;	// how big is a frame in quadwords
    //    /* 0x0E8 */ uint32_t	first_frame;	// location of the first frame, last frame first_frame+frame_count or first_frame-1
    //    /* 0x0EC */ uint32_t 	trig_frame;	// location of the trigger frame
    //    /* 0x0F0 */ uint32_t	trig_time_s;	// time in seconds from the start of epoch
    //    /* 0x0F4 */ uint32_t	trig_time_ns;	// nanoseconds from the last second
    //    /* 0x0F8 */ uint32_t 	sov_off;	// start of video offset in quadwords
    //
    //    /* 0x0FC */ uint32_t	as_shot_red;		//!< The AsShotNeutral value for the red channel.
    //    /* 0x100 */ uint32_t	as_shot_grn;		//!< The AsShotNeutral value for the green channel.
    //    /* 0x104 */ uint32_t	as_shot_blu;		//!< The AsShotNeutral value for the blue channel.
    //
    //    // The following are display (IPM) settings not record (ICM) settings
    //    // so they are not saved to the partition at the completion of record but
    //    // later when the user indicate that they are finished with the partition
    //    /* 0x108 */ uint32_t	matrix_coeff1_red;		//!< the next values are for the matrix coefficients for red,green,blue
    //    /* 0x10C */ uint32_t	matrix_coeff2_red;
    //    /* 0x110 */ uint32_t	matrix_coeff3_red;
    //    /* 0x114 */ uint32_t	matrix_coeff1_grn;
    //    /* 0x118 */ uint32_t	matrix_coeff2_grn;
    //    /* 0x11C */ uint32_t	matrix_coeff3_grn;
    //    /* 0x120 */ uint32_t	matrix_coeff1_blu;
    //    /* 0x124 */ uint32_t	matrix_coeff2_blu;
    //    /* 0x128 */ uint32_t	matrix_coeff3_blu;
    //    /* 0x12C */ uint32_t	wb_red;			//!< the next 3 values describe the whitebalance handling of red,grn,blu
    //    /* 0x130 */ uint32_t	wb_grn;
    //    /* 0x134 */ uint32_t	wb_blu;
    //
    //    /* 0x138 */ uint8_t	multslope[2];	// multislope settings 1 byte DS, 1 byte TS
    //    /* 0x13A */ uint8_t	trig_set;	// trigger settings: 0-100 for percent, 0x7F for frame count
    //    /* 0x13B */ uint8_t	sync_in_set;	// sync in settings TBD (master/slave)
    //    /* 0x13C */ uint8_t	sync_out_set;	// sync out settings (TBD)
    //
    //    /* 0x13D */ uint8_t	brightness;	// brightness setting of 0-200 for -1.00 to 1.00
    //    /* 0x13E */ uint8_t	contrast;	// contrast setting of 0-200 for -1.00 to 1.00
    //    /* 0x13F */ uint8_t	old_gamma;	// retired 2.2.1, 10-255 (0.10-2.55) but allowed 0.10-5.00
    //    /* 0x140 */ uint8_t	old_red;	// retired 2.2.1, needed 16 bits
    //    /* 0x141 */ uint8_t	old_green;	// retired 2.2.1, needed 16 bits
    //    /* 0x142 */ uint8_t	old_blue;	// retired 2.2.1, needed 16 bits
    //
    //    //was the image recorded with sensor (Lupa1300) on chip fpn turned on, the fpga's fpn turned on
    //    //or nothing turned on. The mask match what's described for GIGE_REG_FPN
    //    /* 0x143 */ uint8_t	fpn_status;
    //
    //    // The following are offsets and lengths into other areas of the file. Some of these
    //    // are not defined yet so are not filled in yet.
    //    /* 0x144 */ uint32_t 	corr_off;	// correction table offset in quadwords
    //    /* 0x148 */ uint32_t 	corr_len;	// correction table length in quadwords
    //    /* 0x14C */ uint32_t 	sample_off;	// sample data offset in quadwords (future)
    //    /* 0x150 */ uint32_t 	sample_len;	// sample data length in quadwords (future)
    //    /* 0x154 */ uint32_t 	audio_off;	// audio data offset in quadwords (future)
    //    /* 0x158 */ uint32_t 	audio_len;	// audio data length in quadwords (future)
    //
    //    /* 0x15C */ uint32_t 	trig_set_frames;// trigger frames setting
    //    /* Added in 1.7.6 */
    //    /* 0x160 */ uint8_t	comment[64];	// user comment about this recording
    //    /* Added in 2.0.0 */
    //    /* 0x1a0 */ uint32_t 	sensor_opts;    // sensor binning, subsampling, and HDR options
    //    /* Added in 2.0.5 */
    //    /* 0x1a4 */ uint16_t 	black_offset;   // black level offset for saved CT in CAP or LR capture
    //    /* 0x1a6 */ uint8_t 	sensor_dac;     // sensor DAC VREF for saved CT in CAP or LR capture
    //    /* 0x1a7 */ uint8_t 	sensor_vrefcol; // sensor VREFCOL for saved CT in CAP or LR capture
    //    /* 0x1a8 */ uint16_t    sensor_gain;	// sensor gain in canonical form ( x 100 )
    //    /* Added in 2.2.2 */
    //    /* 0x1aa */ uint16_t	white_bal;	// Standard lighting option or CUSTOM
    //    /* 0x1ac */ uint16_t	red;		// red value of RGB gain 8.8 format
    //    /* 0x1ae */ uint16_t	green;          // green value of RGB gain 8.8 format
    //    /* 0x1b0 */ uint16_t	blue;           // blue value of RGB gain 8.8 format
    //    /* 0x1b2 */ uint16_t	gamma;		// 10-500 for 0.10-5.00
    //    /* 0x1b4 */ uint32_t	dc_offset_red;	// DC offset to supplement matrix_coeff...
    //    /* 0x1b8 */ uint32_t	dc_offset_grn;
    //    /* 0x1bc */ uint32_t	dc_offset_blu;
    //    /* Added in 2.3.0 */
    //    /* 0x1c0 */ uint32_t	lut_id;		// LUT number
    //    /* 0x1c4 */ uint16_t	lut_knots[ LUT_MAX_KNOT_COUNT * 2 ]; // Spline knots for non-zero LUT.
    //    /* 0x204 */ /* size of pm_metadata structure */
    //} pm_metadata;
    //#pragma pack(0)
    //
    //// Sizes of previous versions of pm_metadata.
    this.GIGE_PM_META_SIZE_1_7_5 = 0x15c;
    this.GIGE_PM_META_SIZE_1_9_99 = 0x1a0;
    this.GIGE_PM_META_SIZE_2_0_4 = 0x1a4;
    this.GIGE_PM_META_SIZE_2_2_1 = 0x1ac; // Structure size for 2.2.1 or earlier
    this.GIGE_PM_META_SIZE_2_2_99 = 0x1c0; // Structure size for last 2.2 release
    //
    //#pragma pack(1)
    ////! FCP request header structure. All FCP requests must have one
    ////! unless otherwise mentioned all fields are assumed to be network byte order (NBO)
    //typedef struct fcp_request_header_type
    //{
    //    char code;        //!< message code, should always be set to 0x42 on requests
    //    char flag;        //!< flags which are message specific
    //    uint16_t command; //!< command
    //    uint16_t length;  //!< length of the data portion of the message
    //    uint16_t req_id;  //!< request id, should be echoed back to the originator
    //} fcp_request_header;
    //#pragma pack(0)
    //
    //#pragma pack(1)
    ////! FCP response header structure. All FCP responses must have one
    ////! unless otherwise mentioned all fields are assumed to be network byte order (NBO)
    //typedef struct fcp_response_header_type
    //{
    //    uint16_t  status;  //!< was the command successful
    //    uint16_t  command; //!< command
    //    uint16_t  length;  //!< length of the data portion of the message,
    //    uint16_t  ack_id;  //!< request id echoed back
    //} fcp_response_header;
    //#pragma pack(0)
    //
    //
    //#pragma pack(1)
    ////! Union structure to allow the two header types to share memory
    ////! unless otherwise mentioned all fields are assumed to be network byte order (NBO)
    //typedef struct gige_header_type
    //{
    //    union
    //    {
    //        fcp_request_header	req;
    //        fcp_response_header	resp;
    //        char			raw[FCP_MSG_HDR_SIZE];
    //    };
    //} fcp_header;
    //#pragma pack(0)
    //
    //#pragma pack(1)
    ////! Definition of an EVENT message. These are events sent from the camera to the application
    ////! which has registered for them. No ack's are expected or handled.
    ////! The header is the standard fcp_request_header. Unless otherwise mentioned all fields are
    ////! assumed to be network byte order (NBO)
    //typedef struct gige_fep_data_type
    //{
    //    uint16_t    reserved;	//!< reserved field
    //    uint16_t    event_id;	//!< event number really the register number. 0-36863 are reserved.
    //    uint16_t    stream_ch;	//!< stream channel associated with this event 0xFFFF if no stream.
    //    uint16_t    block_id;	//!< ID of the data block associated with event, 0 if no block
    //    uint32_t    time_high;	//!< high part of the timestamp when the event was generated
    //    uint32_t    time_low;	//!< low part of the timestamp when the event was generated.
    //} fep_msg;
    //#pragma pack(0)
    //
    //#pragma pack(1)
    ////! Definition of an EVENT_DATA message. These are events sent from the camera to the application
    ////! whenever a numeric register changes and the application is registered for them. The difference
    ////! between this message and the EVENT message is that the new value of the register is included with
    ////! the message. No ack's are expected or handled.
    ////! The header is the standard fcp_request_header. Unless otherwise mentioned all fields are
    ////! assumed to be network byte order (NBO)
    //typedef struct gige_fed_data_type
    //{
    //    uint16_t    reserved;	//!< reserved field
    //    uint16_t    event_id;	//!< event number really the register number. 0-36863 are reserved.
    //    uint16_t    stream_ch;	//!< stream channel associated with this event 0xFFFF if no stream.
    //    uint16_t    block_id;	//!< ID of the data block associated with event, 0 if no block
    //    uint32_t    time_high;	//!< high part of the timestamp when the event was generated
    //    uint32_t    time_low;	//!< low part of the timestamp when the event was generated.
    //    uint32_t    reg_val_l;	//!< the new value of the numeric register.
    //} fed_msg;
    //#pragma pack(0)
    //
    //#pragma pack(1)
    ////! Definition of a FCP message. Requests and responses share the same structure.
    ////! unless otherwise mentioned all fields are assumed to be network byte order (NBO)
    //typedef struct gige_fcp_msg_type
    //{
    //    fcp_header header;	 //!< the fcp header 8 bytes
    //    union
    //    {
    //        char		data_b[FCP_MSG_DATA_SIZE];	//!< message data in bytes
    //        uint16_t	data_w[FCP_MSG_DATA_SIZE/2];	//!< message data in words
    //        uint32_t	data_l[FCP_MSG_DATA_SIZE/4];	//!< message data in longs
    //        fep_msg        	fep;                           //!< if header is GIGE_EVENT_CMD
    //        fed_msg         fed;                           //!< if header is GIGE_EVENTDATA_CMD
    //    };
    //} fcp_msg;
    //#pragma pack(0)
    //
    //
    ////! The following structures define the FSP (Streaming) protocol
    ////! messages. Which is broken up into three types of messages,
    ////! leader, payload, and trailer.
    ////! Type of packet
    this.FSP_PKT_FMT_LEADER = 1;
    this.FSP_PKT_FMT_TRAILER = 2;
    this.FSP_PKT_FMT_PAYLOAD = 3;
    //
    //#pragma pack(1)
    ////! Definition of the header on all FSP messages, leader, payload, and trailer
    ////! unless otherwise mentioned all fields are assumed to be network byte order (NBO)
    //typedef struct fsp_header_type
    //{
    //    uint16_t	status;		//!< status of the streaming operation
    //    uint16_t	block_id;	//!< ID of the data block. Sequential and incrementing starting at 1
    //    uint8_t	pkt_fmt;  	//!< packet format, 1=Data Leader, 2=Data Trailer, 3=Data Payload
    //    uint8_t     pkt_id[3];	//!< ID of the packet in the block, reset to 0 on new block
    //} fsp_header;
    //#pragma pack(0)
    //
    ////! Type of payload data, not sure which of these formats we are going to support yet.
    this.FSP_PAYLOAD_IMAGE = 0x1;
    this.FSP_PAYLOAD_RAW = 0x2;
    this.FSP_PAYLOAD_FILE = 0x3;
    this.FSP_PAYLOAD_CHUNK = 0x4;
    this.FSP_PAYLOAD_EXT_CHUNK = 0x5;
    this.FSP_PAYLOAD_DEV_SPEC = 0x8000;
    this.FSP_FASTEC_ID = 0x4649;
    //
    //#pragma pack(1)
    ////! Definition of a generic FSP leader message, contains a header
    //typedef struct fsp_leader_type
    //{
    //    fsp_header	header;		//!< the header defined earlier
    //    uint16_t	magic_id;	//!< not used
    //    uint16_t	payload_type;	//!< Unique type identifying type of data block to expect
    //    uint32_t	timestamp_high; //!< high 32 bits of the timestamp when block was generated
    //    uint32_t	timestamp_low;  //!< low 32 bits of the timestamp when block was generated
    //} fsp_leader;
    //#pragma pack(0)
    //
    ////! Pixel formats
    this.FSP_PIX_MONO8 = 0x01080001; //!< 8 bit mono
    //
    //#pragma pack(1)
    ////! Definition of a FSP image type leader message, contains the generic leader
    //typedef struct fsp_leader_image_type
    //{
    //    fsp_leader	leader;		//!< generic leader
    //    uint32_t	pixel_format;	//!< format of the pixel
    //    uint32_t	size_x;		//!< Width of the image in pixels
    //    uint32_t	size_y;		//!< Height of the image in pixels
    //    uint32_t	offset_x;	 //!< Offset in pixels from image origin
    //    uint32_t	offset_y;	 //!< Offset in pixels from image origin
    //    uint16_t	padding_x;	//!< Horizontal padding in bytes. Num extra bytes at end of line
    //    uint16_t	padding_y;	//!< Vertical padding in bytes. Num of extra bytes at end of image
    //} fsp_leader_image;
    //#pragma pack(0)
    //
    //#pragma pack(1)
    ////! Definition of a FSP file type leader message, contains the generic leader
    this.FSP_LEADER_FILE_NAME_LEN = 20;
    //typedef struct fsp_leader_file_type
    //{
    //    fsp_leader	leader;		//!< generic leader
    //    uint32_t	ps_high;	//!< high bytes of the payload size
    //    uint32_t	ps_low;		//!< low bytes of the payload size
    //    char		file_name[ FSP_LEADER_FILE_NAME_LEN ];  //!< filename of the image file
    //} fsp_leader_file;
    //#pragma pack(0)
    //
    //#pragma pack(1)
    ////! Definition of a FSP raw type leader message, contains the generic leader
    //typedef struct fsp_leader_raw_type
    //{
    //    fsp_leader	leader;		//!< generic leader
    //    uint32_t	data_size_high; //!< payload data size in bytes (high part)
    //    uint32_t	data_size_low;  //!< payload data size in bytes (low part)
    //} fsp_leader_raw;
    //#pragma pack(0)
    //
    //#pragma pack(1)
    ////! Definition of a FSP payload data type
    //typedef struct fsp_payload_type
    //{
    //    fsp_header	header;	 //!< the header defined earlier
    //    char		data;	 //!< first byte data, rest will follow.
    //} fsp_payload;
    //#pragma pack(0)
    //
    //#pragma pack(1)
    ////! Definition of a FSP generic trailer, most of the trailers are of this
    ////! type.
    //typedef struct fsp_trailer_type
    //{
    //    fsp_header	header;		//!< the header defined earlier
    //    uint16_t	reserved;	//!< not used
    //    uint16_t	payload_type;	//!< Unique type identifying type of data block to expect
    //} fsp_trailer;
    //#pragma pack(0)
    //
    //#pragma pack(1)
    ////! Definition of a FSP image trailer
    //typedef struct fsp_trailer_image_type
    //{
    //    fsp_trailer	trailer;	//!< the generic trailer header
    //    uint32_t	size_y;		//!< Height of the image in pixels
    //} fsp_trailer_image;
    //#pragma pack(0)
    //
    //#pragma pack(1)
    ////! Definition of a FSP file trailer
    //typedef struct fsp_trailer_file_type
    //{
    //    fsp_header	header;		//!< the header defined earlier
    //    uint16_t	reserved;	//!< not used
    //    uint16_t	payload_type;	//!< Unique type identifying type of data block to expect
    //} fsp_trailer_file;
    //#pragma pack(0)
    //
    //
    //
    //#pragma pack(1)
    ////! Definition of wifi scan result
    //typedef struct wifi_scan_results_type
    //{
    //    char     ssid[33];      // upto 32 chars plus null
    //    uint8_t  security;      // using same values as GIGE_REG_WIFI_AP_CFG reg
    //    uint8_t  adhoc;         // flag, yes or no
    //    uint8_t  signal_level;  // 0 to 100
    //} wifi_scan_results;
    //#pragma pack(0)
    //
    //
    //
    //#endif // GIGE_MSG_H
    //#ifdef __cplusplus
    //}
    //#endif
}
