//------------------------------------------------
// fastec_video.js
//
// Copyright 2010-2018 (c) Fastec Imaging as an unpublished work.
// All Rights Reserved.
//
// The information contained herein is confidential property of
// Fastec Imaging. The use, copying, transfer or disclosure of such
// information is prohibited except by express written agreement
// with Fastec Imaging.
//
// Fastec Imaging Camera Control Web Application
// Video Panel Support
//------------------------------------------------

// Setup some defaults for the widht/height. These will
// likely change at runtime.
var propVideoFrameAspectWidth = 1280;
var propVideoFrameAspectHeight = 1024;
var propVideoFrameSmallestPercent = 0.1;
var propVideoFrameSmallestWidth =
    propVideoFrameAspectWidth * propVideoFrameSmallestPercent;
var propVideoFrameSmallestHeight =
    propVideoFrameAspectHeight * propVideoFrameSmallestPercent;

var gVideoImgTopZ = 100; // z-index for visible image

function availHeight() {
    var my_height = window.innerHeight;
    var padding = $("#page1Header").height() + $("#page1Footer").height();

    padding += $("#VideoToolbar").height();

    // Is the capture information being displayed?
    if ($("#videoCaptureSectionID").is(":visible")) {
	padding += $("#videoCaptureSectionID").height();
    }

    // Is the review information being displayed?
    if ($("#reviewSectionID").is(":visible")) {
	padding += $("#reviewSectionID").height();
    }

    // Need a little slop to account for padding, borders, etc.
    // Value derived empirically.
    padding += 80;

    // Adjust for padding.
    my_height = my_height - padding;

    return my_height;
}

function availWidth() {
    var my_width = $("#VideoBody").width(); // Total available width.
    var padding = (window.innerWidth - my_width) / 2;

    // Adjust for padding.
    my_width = my_width - padding;

    return my_width;
}

//------------------------------------
// redraw video frame for aspect ratio change
//------------------------------------
function videoSyncWithAR(forceResize) {
    var arChanged = false;

    // See if either dimension changed.
    if (propVideoFrameAspectWidth != gCameraData.recROIWidth) {
        propVideoFrameAspectWidth = gCameraData.recROIWidth;
        arChanged = true;
    }
    if (propVideoFrameAspectHeight != gCameraData.recROIHeight) {
        propVideoFrameAspectHeight = gCameraData.recROIHeight;
        arChanged = true;
    }

    // Handle the resizing of the video window.
    if (arChanged || forceResize) {
        // Also recalculate the smallest width/height for this aspect ratio
        propVideoFrameSmallestWidth =
            propVideoFrameAspectWidth * propVideoFrameSmallestPercent;
        propVideoFrameSmallestHeight =
            propVideoFrameAspectHeight * propVideoFrameSmallestPercent;

        // Resize the image.
        resizeKeepingAspectRatio();
    }
}

//------------------------------------
// Common handler for resizing allowing the size to maintain
// the aspect ratio of the video frame
//------------------------------------
function resizeKeepingAspectRatio() {
    var aspectRatio = propVideoFrameAspectHeight / propVideoFrameAspectWidth;
    var winWidth = availWidth();
    var winHeight = availHeight();
    var newImgWidth = winWidth;
    var newImgHeight = winHeight;

//     fastecLogToConsole(gLogAll, "avail: [" + winWidth + ", " + winHeight + "]");
//     fastecLogToConsole(gLogAll, "win: [" + window.innerWidth + ", " + window.innerHeight + "]");

    // Check extents if rectangle becomes too small don't change it and constrain within smallest allowed
    if (
        newImgWidth < propVideoFrameSmallestWidth ||
        newImgHeight < propVideoFrameSmallestHeight
    ) {
        // We're trying to go too small. Clip at the minimum.
        newImgWidth = propVideoFrameSmallestWidth;
        newImgHeight = propVideoFrameSmallestHeight;
    } else {
        // Allow for calculation to make smaller based on size of window
        // Which is smaller width or height - modify based on this
        var tmpImgHeight = newImgWidth * aspectRatio;
        tmpImgHeight = Math.floor(tmpImgHeight);

        // If we say the new window's width is the image width, can
        // we fit the height in the window (maintaining aspect ratio)?
        if (newImgHeight < tmpImgHeight) {
            // The height is the smallest, so calculate what the width needs to be.
            newImgWidth = newImgHeight / aspectRatio;
            newImgWidth = Math.floor(newImgWidth);
        } else {
            // The width is the smallest, so just use the calculated height since
            // that fits just fine.
            newImgHeight = tmpImgHeight;
        }

        // If the new height is out of visible bounds constrain it and recalculate the
        // width using the width-driven aspect ratio
        if (newImgHeight > winHeight) {
            // Need to drive using a smaller height and recalculate aspect ratio width.
            newImgHeight = winHeight;

            // We use a different aspect ratio for this calculation (width:height).
            var aspectW2HRatio =
                propVideoFrameAspectWidth / propVideoFrameAspectHeight;

            // Which is smaller width or height - modify based on this
            var tmpImgWidth = newImgHeight * aspectW2HRatio;
            tmpImgWidth = Math.floor(tmpImgWidth);
            if (newImgWidth < tmpImgWidth) {
                newImgHeight = newImgWidth / aspectW2HRatio;
                newImgHeight = Math.floor(newImgHeight);
            } else {
                newImgWidth = tmpImgWidth;
            }
        }
    }

    // Make sure the width and height are constrained within smallest allowed (sanity check)
    if (
        newImgWidth < propVideoFrameSmallestWidth ||
        newImgHeight < propVideoFrameSmallestHeight
    ) {
        newImgWidth = propVideoFrameSmallestWidth;
        newImgHeight = propVideoFrameSmallestHeight;
    }

    // Only change if there is a difference.
    if (
         newImgWidth != $(".VideoImage").width() ||
         newImgHeight != $(".VideoImage").height()
     ) {
         $(".VideoImage").width(newImgWidth);
         $(".VideoImage").height(newImgHeight);
     }
}
