//------------------------------------------------
// fastec_progbars.js
//
// Copyright 2018 (c) Fastec Imaging as an unpublished work.
// All Rights Reserved.
//
// The information contained herein is confidential property of
// Fastec Imaging. The use, copying, transfer or disclosure of such
// information is prohibited except by express written agreement
// with Fastec Imaging.
//
// Fastec Imaging Camera Control Web Application
// Progress bar objects
//------------------------------------------------

//---------------------------------------------------
// The Arm/Trigger percent control object>
// Note:  to overcome some of the problems with "this" and
// event handlers there is a global object available as THE
// one and only capture record control
//---------------------------------------------------
function fastecArmTrigCtl() {
    try {
        this.minVal = 0;
        this.maxVal = 100;
        this.curVal = 0;
        this.triggerFrame = 0;

        this.flashingGauge = false; // will be able to "flash" percentage gauge as it rises

        this.initCtl = function() {
            this.setMinMaxCur(this.minVal, this.maxVal, this.curVal);
        };

        // Setup a trigger frame value.
        this.setTFrame = function(in_triggerFrame) {
            if (in_triggerFrame < this.minVal) {
		this.triggerFrame = this.minVal;
	    }
            else if (in_triggerFrame > this.maxVal) {
		this.triggerFrame = this.maxVal;
	    }
            else {
		this.triggerFrame = in_triggerFrame;
	    }
        };

        // Setup percent gauge range.
        this.setMinMaxCur = function(in_minVal, in_maxVal, in_curVal) {
            this.minVal = in_minVal;
            this.maxVal = in_maxVal;
            this.curVal = in_curVal;

            // Make sure values are all in range
            if (this.minVal > this.maxVal) this.minVal = this.maxVal;
            this.setNewCurVal(in_curVal);
        };

        // Adjust gauge percent.
        this.setNewCurVal = function(in_curVal) {
            if (in_curVal < this.minVal) {
		this.curVal = this.minVal;
	    }
            else if (in_curVal > this.maxVal) {
		this.curVal = this.maxVal;
	    }
            else {
		this.curVal = in_curVal;
	    }

            // Set the new percent style for the gauge.
            var totalVal = this.maxVal - this.minVal + 1;

            //var pct = fmtIntegerRoundUp(this.curVal * 100 / totalVal);
            var pct = this.curVal * 100 / totalVal;

            // If the pct is > 99.0 make it 100.
            if (pct > 99.0) {
		pct = 100;
	    }

            // Force integer math.
            pct = fastecMakeInteger(pct);

            var pctStr = pct + "%";
            $("#pbarGaugeID").css("width", pctStr);

            // Install percentage of buffer information.
            $("#capPercentID").html("Position: " + pctStr);

            // Install the current/tframe/maxframe string.
            var frameInfoStr = this.curVal + "/" + this.triggerFrame + "/" + this.maxVal;

            // If in LR Append mode muck with settings.
            if (gCameraData.isCameraInLRAppendMode()) {
		frameInfoStr = this.curVal + "/" + this.curVal + "/" + this.maxVal;
	    }

            $("#capFrameInfo").html(frameInfoStr);
        };

        // Animation handlers for flashing support
        this.animateFlash = function() {
            if (gArmTrigPctCtrl.flashingGauge) {
		$("#pbarGaugeID").animate({ opacity: 0.2 }, 200, gArmTrigPctCtrl.animateSolid);
	    }
        };

        this.animateSolid = function() {
            if (gArmTrigPctCtrl.flashingGauge) {
		$("#pbarGaugeID").animate({ opacity: 1 }, 200, gArmTrigPctCtrl.animateFlash);
	    }
            else {
		$("#pbarGaugeID").animate({ opacity: 1 }, 200);
	    }
        };

        // Animate a flash for the gauge.
        this.flashGauge = function(flashIt) {
            if (flashIt) {
		this.flashingGauge = true;
	    }
            else {
		this.flashingGauge = false;
	    }

            if (this.flashingGauge) {
		this.animateFlash();
	    }
            else {
		this.animateSolid();
	    }
        };

        // Set new gauge color.
        this.setGaugeColor = function(newColorStr) {
            $("#pbarGaugeID").css("background-color", newColorStr);
        };

        // Set new bar color.
        this.setBarColor = function(newColorStr) {
            $("#pbarBaseID").css("background-color", newColorStr);
        };
    } catch (err) {
        var theDetails = "caught: fastecPctCtl-" + err.description;
        gFaultHandler.logError(theDetails);
    }
}
