//------------------------------------------------
// fastec_err.js
//
// Copyright 2010 (c) Fastec Imaging as an unpublished work.
// All Rights Reserved.
//
// The information contained herein is confidential property of
// Fastec Imaging. The use, copying, transfer or disclosure of such
// information is prohibited except by express written agreement
// with Fastec Imaging.
//
// The Fastec Imaging Series3 Web Application
// error handling objects --
//------------------------------------------------

var gFaultHandler = new faultHandler();

//------------------------------------
// fault handling entry object errors
//------------------------------------
function faultEntry() {
    try {
        var severitySettings = {
            faultNotSet: 0, // not set
            faultError: 1, // a major problem has occurred
            faultWarning: 2, // a minor problem has occurred (may indicate more serious error in future)
            faultInfo: 4 // a minor issue has occured should be logged
        };
        this.faultSeverity = severitySettings.faultNotSet;
        this.faultTime = "0";
        this.faultDetails = "";

        // common logic for setting the rest of members
        this.setDetails = function(theDetails) {
            this.faultDetails = theDetails;
            var d = new Date();
            this.faultTime = d.getTime();
        };

        // set a fault error condition
        this.setFaultError = function(theDetails) {
            this.faultSeverity = severitySettings.faultError;
            this.setDetails(theDetails);
        };
        // set a fault warning condition
        this.setFaultWarning = function(theDetails) {
            this.faultSeverity = severitySettings.faultWarning;
            this.setDetails(theDetails);
        };
        // set a fault information condition
        this.setFaultInfo = function(theDetails) {
            this.faultSeverity = severitySettings.faultInfo;
            this.setDetails(theDetails);
        };
    } catch (err) {}
}

//------------------------------------
// fault handling object for errors
//------------------------------------
function faultHandler() {
    try {
        this.faultList = new Array(); // manages faults for the program

        // right now these are very similar but as errors are generated
        // and categorized this functionality may need to be specialized.

        // handle an error  fault
        this.logError = function(theDetails) {
            var newFaultEntry = new faultEntry();
            newFaultEntry.setFaultError(theDetails);
            this.faultList.push(newFaultEntry);
        };

        // handle an warning fault
        this.logWarning = function(theDetails) {
            var newFaultEntry = new faultEntry();
            newFaultEntry.setFaultWarning(theDetails);
            this.faultList.push(newFaultEntry);
        };

        // handle an information fault
        this.logInfo = function(theDetails) {
            var newFaultEntry = new faultEntry();
            newFaultEntry.setFaultInfo(theDetails);
            this.faultList.push(newFaultEntry);
        };
    } catch (err) {}
}
