#!/bin/bash
#set -x

# Determine if the camera is integrated or not.
isIntegrated() {
    NODE_NAME=$(lspci -s "03:00.0")
    if [ -z "$NODE_NAME" ]; then
        false
    else
        true
    fi
}

# Get the PCIe information for a node.
# $1=node
getInfo() {
    if [ "$#" -ne 1 ]; then
        echo "getInfo takes an argument: node"
        return 1
    fi
    node=$1

    # Get the information we're interested in.
    NODE_NAME=$(lspci -s "$node")
    LINK_STA=$(lspci -vv -s "$node" | grep -E 'LnkSta:')
}

echo =================================
date

if isIntegrated; then
    getInfo "01:00.0" 
    if [ -z "$NODE_NAME" ]; then
        echo "01:00.0 not found" 
    else
        echo $NODE_NAME ">>" $LINK_STA
    fi

    getInfo "02:01.0" 
    if [ -z "$NODE_NAME" ]; then
        echo "02:01.0 not found" 
    else
        echo $NODE_NAME ">>" $LINK_STA
    fi

    getInfo "02:02.0" 
    if [ -z "$NODE_NAME" ]; then
        echo "02:02.0 not found" 
    else
        echo $NODE_NAME ">>" $LINK_STA
    fi

    getInfo "03:00.0" 
    if [ -z "$NODE_NAME" ]; then
        echo "03:00.0 not found" 
    else
        echo $NODE_NAME ">>" $LINK_STA
    fi

    getInfo "04:00.0" 
    if [ -z "$NODE_NAME" ]; then
        echo "04:00.0 not found" 
    else
        echo $NODE_NAME ">>" $LINK_STA
    fi
else
    getInfo "01:00.0" 
    if [ -z "$NODE_NAME" ]; then
        echo "01:00.0 not found" 
    else
        echo $NODE_NAME ">>" $LINK_STA
    fi

    getInfo "02:02.0" 
    if [ -z "$NODE_NAME" ]; then
        echo "02:02.0 not found" 
    else
        echo $NODE_NAME ">>" $LINK_STA
    fi

    getInfo "04:00.0" 
    if [ -z "$NODE_NAME" ]; then
        echo "04:00.0 not found" 
    else
        echo $NODE_NAME ">>" $LINK_STA
    fi

    getInfo "05:01.0" 
    if [ -z "$NODE_NAME" ]; then
        echo "05:01.0 not found" 
    else
        echo $NODE_NAME ">>" $LINK_STA
    fi

    getInfo "05:02.0" 
    if [ -z "$NODE_NAME" ]; then
        echo "05:02.0 not found" 
    else
        echo $NODE_NAME ">>" $LINK_STA
    fi

    getInfo "06:00.0" 
    if [ -z "$NODE_NAME" ]; then
        echo "06:00.0 not found" 
    else
        echo $NODE_NAME ">>" $LINK_STA
    fi

    getInfo "07:00.0" 
    if [ -z "$NODE_NAME" ]; then
        echo "07:00.0 not found" 
    else
        echo $NODE_NAME ">>" $LINK_STA
    fi
fi

